/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.cli;

import java.util.Objects;
import java.util.function.Function;

public class Bounds<T extends Comparable<? super T>> {
    private final T lower;
    private final T upper;

    public Bounds(T bound1, T bound2) {
        if (bound1 == null || bound2 == null) {
            throw new NullPointerException("Bound can't contain null value");
        }
        if (bound1.compareTo(bound2) < 0) {
            this.lower = bound1;
            this.upper = bound2;
        } else {
            this.lower = bound2;
            this.upper = bound1;
        }
    }

    public T getLower() {
        return this.lower;
    }

    public T getUpper() {
        return this.upper;
    }

    public boolean isDot() {
        return Objects.equals(this.lower, this.upper);
    }

    public String asString() {
        return this.asString(String::valueOf);
    }

    public String asString(Function<T, String> formatter) {
        if (this.isDot()) {
            return formatter.apply(this.lower);
        }
        return formatter.apply(this.lower) + " - " + formatter.apply(this.upper);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bounds bounds = (Bounds)o;
        return Objects.equals(this.lower, bounds.lower) && Objects.equals(this.upper, bounds.upper);
    }

    public int hashCode() {
        return Objects.hash(this.lower, this.upper);
    }
}

