/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.cli;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.xblackcat.sjpu.cli.Bounds;
import org.xblackcat.sjpu.cli.InvalidOptionException;
import org.xblackcat.sjpu.cli.progress.LogPrintStream;
import org.xblackcat.sjpu.cli.progress.NullPrintStream;
import org.xblackcat.sjpu.cli.progress.Verbosity;
import org.xblackcat.sjpu.cli.reader.ProgressOutStream;

public class OptionUtils {
    private static final char[] multipliers = new char[]{' ', 'k', 'm', 'g', 't'};
    public static final Function<Number, Function<String, String>> POSITIVE_VALUE_CHECK = n -> n.doubleValue() > 0.0 ? null : name -> name + " should be positive";
    public static final Function<Number, Function<String, String>> LIMIT_VALUE_CHECK = n -> n.longValue() >= -1L ? null : name -> name + " should be positive, zero or -1";
    public static final Function<Number, Function<String, String>> ANY_VALUE_CHECK = n -> null;
    public static final Function<Number, Function<String, String>> PERCENT_VALUE_CHECK = n -> n.doubleValue() < 0.0 ? name -> name + " can not be negative" : (n.doubleValue() > 1.0 ? name -> name + " can not be greater than 1" : null);
    public static Function<String, LocalDateTime> TO_TIME_PERIOD_BOUND_PARSER = s -> {
        if ("now".equalsIgnoreCase((String)s)) {
            return LocalDateTime.now();
        }
        try {
            return LocalDateTime.parse(s);
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                return LocalDate.parse(s).atStartOfDay();
            }
            catch (DateTimeParseException dateTimeParseException2) {
                try {
                    return LocalDateTime.now().plus(Duration.parse(s));
                }
                catch (DateTimeParseException dateTimeParseException3) {
                    throw new IllegalArgumentException("Failed to parse date/time bound: " + s);
                }
            }
        }
    };
    public static Function<String, Duration> TO_DURATION_BOUND_PARSER = s -> {
        if ("0".equalsIgnoreCase((String)s)) {
            return Duration.ZERO;
        }
        try {
            Duration duration = Duration.parse(s);
            if (duration.isNegative()) {
                throw new IllegalArgumentException("Duration bound can't be negative: " + s);
            }
            return duration;
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("Unparsable time shift: " + s, e);
        }
    };

    public static LogPrintStream parseProgressOutputStream(CommandLine line, String optionName) throws InvalidOptionException {
        ProgressOutStream str;
        Verbosity verbosity = OptionUtils.parseVerbosity(line);
        if (line.hasOption(optionName)) {
            String value = line.getOptionValue(optionName);
            str = ProgressOutStream.parseValue(value);
            if (str == null) {
                throw new InvalidOptionException("Can not parse options. Please, check the command line. Invalid option value for option progress [" + optionName + "]: " + value);
            }
        } else {
            str = ProgressOutStream.Default;
        }
        return new LogPrintStream(verbosity, str.getStream());
    }

    public static Verbosity parseVerbosity(CommandLine cmd) {
        boolean quiet = cmd.hasOption("q");
        boolean verbose = cmd.hasOption("v");
        boolean brief = cmd.hasOption("b");
        Verbosity verbosity = verbose ? Verbosity.Verbose : (brief ? Verbosity.Brief : (quiet ? Verbosity.Quiet : Verbosity.Normal));
        return verbosity;
    }

    public static BufferedReader getReader(CommandLine line, String optionName) throws IOException {
        String value;
        if (line.hasOption(optionName) && !Objects.equals("-", value = line.getOptionValue(optionName))) {
            return Files.newBufferedReader(Paths.get(value, new String[0]));
        }
        return new BufferedReader(new InputStreamReader(System.in));
    }

    public static PrintStream getPrintStream(CommandLine line, String fileOptionName) throws IOException {
        return OptionUtils.getPrintStream(line, true, fileOptionName);
    }

    public static PrintStream getPrintStream(CommandLine line, boolean stdOutAsDefault, String fileOptionName) throws IOException {
        if (line.hasOption(fileOptionName)) {
            String outFileName = line.getOptionValue(fileOptionName);
            if (Objects.equals("-", outFileName)) {
                return System.out;
            }
            return new PrintStream(new BufferedOutputStream(Files.newOutputStream(Paths.get(outFileName, new String[0]), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE)));
        }
        if (stdOutAsDefault) {
            return System.out;
        }
        return new NullPrintStream();
    }

    public static <T extends Comparable<? super T>> Bounds<T> getBounds(CommandLine line, String optionName, String description, Function<String, T> convert, String defaultLowerBound, String defaultUpperBound) throws InvalidOptionException {
        return OptionUtils.getBounds(line, optionName, description, convert, (Comparable)convert.apply(defaultLowerBound), (Comparable)convert.apply(defaultUpperBound));
    }

    public static <T extends Comparable<? super T>> Bounds<T> getBounds(CommandLine line, String optionName, String description, Function<String, T> convert, T defaultLowerBound, T defaultUpperBound) throws InvalidOptionException {
        String[] limitOption = line.getOptionValues(optionName);
        try {
            Object limitUpper;
            Object limitLower;
            if (limitOption == null || limitOption.length == 0) {
                limitLower = defaultLowerBound;
                limitUpper = defaultUpperBound;
            } else if (limitOption.length == 1) {
                limitUpper = (Comparable)convert.apply(limitOption[0]);
                limitLower = limitUpper;
            } else {
                limitLower = (Comparable)convert.apply(limitOption[0]);
                limitUpper = (Comparable)convert.apply(limitOption[1]);
            }
            return new Bounds<T>(limitLower, limitUpper);
        }
        catch (NullPointerException | NumberFormatException e) {
            throw new InvalidOptionException("Can not parse " + description + " limits: " + e.getMessage(), e);
        }
    }

    public static Bounds<Integer> getBounds(CommandLine line, String optionName, String description, int defaultLowerBound, int defaultUpperBound) throws InvalidOptionException {
        return OptionUtils.getBounds(line, optionName, description, Integer::parseInt, defaultLowerBound, defaultUpperBound);
    }

    public static String[] getStringList(CommandLine line, String optionName) throws InvalidOptionException {
        return OptionUtils.getStringList(line, optionName, null);
    }

    public static String[] getStringList(CommandLine line, String optionName, String[] defaultValue) throws InvalidOptionException {
        return OptionUtils.getObjectList(line, optionName, defaultValue, UnaryOperator.identity(), String[]::new);
    }

    public static <T> T[] getObjectList(CommandLine line, String optionName, T[] defaultValue, Function<String, T> parser, IntFunction<T[]> arrayGenerator) throws InvalidOptionException {
        String optionValue = StringUtils.trimToNull((String)line.getOptionValue(optionName));
        if (optionValue == null) {
            if (defaultValue == null) {
                throw new IllegalArgumentException(optionName + " is not set");
            }
            return defaultValue;
        }
        List<Object> result = new ArrayList();
        if (!optionValue.startsWith("@")) {
            result = Arrays.stream(StringUtils.splitByWholeSeparator((String)optionValue, (String)",")).filter(StringUtils::isNotBlank).map(parser).collect(Collectors.toList());
        } else {
            InputStreamReader r;
            String fileName = optionValue.substring(1);
            if (Objects.equals("-", fileName)) {
                r = new InputStreamReader(System.in);
            } else {
                try {
                    r = new FileReader(fileName);
                }
                catch (FileNotFoundException e) {
                    throw new InvalidOptionException("Can't open file " + fileName, e);
                }
            }
            try (BufferedReader reader = new BufferedReader(r);){
                String s;
                while ((s = reader.readLine()) != null) {
                    if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                    result.add(parser.apply(s));
                }
            }
            catch (IOException e) {
                throw new InvalidOptionException("Filed to read from " + (Objects.equals("-", fileName) ? "STDIN" : fileName), e);
            }
        }
        return result.stream().toArray(arrayGenerator);
    }

    public static int getIntOption(CommandLine line, String optionName, String name) throws ParseException {
        return OptionUtils.getIntOption(line, optionName, null, name);
    }

    public static int getIntOption(CommandLine line, String optionName, Integer defVal, String valueName) throws ParseException {
        return OptionUtils.getIntOption(line, optionName, POSITIVE_VALUE_CHECK, defVal, valueName);
    }

    public static int getIntOption(CommandLine line, String optionName, Function<Number, Function<String, String>> valueChecker, Integer defVal, String valueName) throws ParseException {
        return OptionUtils.getNumericOption(line, optionName, Number::intValue, valueChecker, defVal, valueName);
    }

    public static long getLongOption(CommandLine line, String optionName, String name) throws ParseException {
        return OptionUtils.getLongOption(line, optionName, null, name);
    }

    public static long getLongOption(CommandLine line, String optionName, Long defVal, String valueName) throws ParseException {
        return OptionUtils.getLongOption(line, optionName, LIMIT_VALUE_CHECK, defVal, valueName);
    }

    public static long getLongOption(CommandLine line, String optionName, Function<Number, Function<String, String>> valueTester, Long defVal, String valueName) throws ParseException {
        return OptionUtils.getNumericOption(line, optionName, Number::longValue, valueTester, defVal, valueName);
    }

    public static double getDoubleOption(CommandLine line, String optionName, String name) throws ParseException {
        return OptionUtils.getDoubleOption(line, optionName, null, name);
    }

    public static double getDoubleOption(CommandLine line, String optionName, Double defVal, String valueName) throws ParseException {
        return OptionUtils.getDoubleOption(line, optionName, Number::doubleValue, defVal, valueName);
    }

    public static double getDoubleOption(CommandLine line, String optionName, Function<Number, Double> valueChecker, Double defVal, String valueName) throws ParseException {
        return OptionUtils.getNumericOption(line, optionName, valueChecker, PERCENT_VALUE_CHECK, defVal, valueName);
    }

    public static <T extends Number> T getNumericOption(CommandLine line, String optionName, Function<Number, T> fieldExtractor, Function<? super T, Function<String, String>> valueTester, T defVal, String valueName) throws ParseException {
        Number value = (Number)line.getParsedOptionValue(optionName);
        if (value != null) {
            Function<String, String> exceptionText = valueTester.apply(defVal);
            if (exceptionText == null) {
                return (T)((Number)fieldExtractor.apply(value));
            }
            throw new IllegalArgumentException(exceptionText.apply(valueName));
        }
        if (defVal != null) {
            return defVal;
        }
        throw new IllegalArgumentException("No value specified for " + valueName);
    }

    public static CommandLine parseCommandLine(String[] args, Options options, String cmdLineSyntax, String description, String ... requiredAnyOpt) {
        return OptionUtils.parseCommandLine(args, true, options, cmdLineSyntax, description, requiredAnyOpt);
    }

    public static CommandLine parseCommandLine(String[] args, boolean showHelpWithoutArgs, Options options, String cmdLineSyntax, String description, String ... requiredAnyOpt) {
        boolean showHelp;
        DefaultParser parser = new DefaultParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
            boolean bl = showHelp = showHelpWithoutArgs && args.length == 0 || line.hasOption('h');
            if (!showHelp && ArrayUtils.isNotEmpty((Object[])requiredAnyOpt)) {
                showHelp = true;
                for (String opt : requiredAnyOpt) {
                    if (!line.hasOption(opt)) continue;
                    showHelp = false;
                    break;
                }
                if (showHelp) {
                    System.err.println("Missing one of required options: " + String.join((CharSequence)", ", requiredAnyOpt));
                }
            }
        }
        catch (ParseException e) {
            System.err.println("Error: " + e.getMessage());
            showHelp = true;
        }
        catch (Throwable e) {
            System.err.println("Unexpected exception: " + e.getMessage());
            e.printStackTrace(System.err);
            System.exit(5);
            return null;
        }
        if (showHelp) {
            HelpFormatter f = new HelpFormatter();
            String suffix = SystemUtils.IS_OS_WINDOWS ? ".exe" : "";
            PrintWriter pw = new PrintWriter(System.out);
            f.printHelp(pw, 74, cmdLineSyntax + suffix, description, options, 1, 3, "", true);
            pw.flush();
            System.exit(1);
            return null;
        }
        return line;
    }

    public static Set<String> getStringsAsSet(CommandLine cmd, String opt) {
        String[] values = cmd.getOptionValues(opt);
        return values != null ? new HashSet<String>(Arrays.asList(values)) : Collections.emptySet();
    }

    public static long parseSize(String str) throws NumberFormatException {
        if (str == null) {
            throw new NullPointerException("Empty string");
        }
        if (str.length() == 0) {
            throw new NumberFormatException("Empty string");
        }
        int shift = 0;
        char lastChar = str.charAt(str.length() - 1);
        if (!Character.isDigit(lastChar)) {
            str = str.substring(0, str.length() - 1);
            lastChar = Character.toLowerCase(lastChar);
            int i = 0;
            do {
                shift += 10;
            } while (++i < multipliers.length && multipliers[i] != lastChar);
            if (i >= multipliers.length) {
                throw new NumberFormatException("Unknown multiplier specified: " + lastChar);
            }
        }
        return Long.parseLong(str) << shift;
    }
}

