/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.cli.progress;

import java.io.PrintStream;
import org.xblackcat.sjpu.cli.progress.Verbosity;

public class LogPrintStream {
    private final Verbosity verbosity;
    private final PrintStream printStream;

    public LogPrintStream(Verbosity verbosity, PrintStream printStream) {
        this.verbosity = verbosity;
        this.printStream = printStream;
    }

    private void log(Verbosity v, String str) {
        if (v.ordinal() <= this.verbosity.ordinal()) {
            this.printStream.print(str);
        }
    }

    private void logln(Verbosity v, String str) {
        if (v.ordinal() <= this.verbosity.ordinal()) {
            this.printStream.println(str);
        }
    }

    public void brief(String str) {
        this.log(Verbosity.Brief, str);
    }

    public void briefln(String str) {
        this.logln(Verbosity.Brief, str);
    }

    public void normal(String str) {
        this.log(Verbosity.Normal, str);
    }

    public void normalln(String str) {
        this.logln(Verbosity.Normal, str);
    }

    public void verbose(String str) {
        this.log(Verbosity.Verbose, str);
    }

    public void verboseln(String str) {
        this.logln(Verbosity.Verbose, str);
    }

    public void print(String str) {
        this.normal(str);
    }

    public void println(String str) {
        this.normalln(str);
    }
}

