/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.cli.progress;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.xblackcat.sjpu.cli.progress.AProgressPublisher;
import org.xblackcat.sjpu.cli.progress.IMultiThreadProgressPublisher;
import org.xblackcat.sjpu.cli.progress.IProgressPublisher;
import org.xblackcat.sjpu.cli.progress.IPublisherBuilder;

public class MultiThreadedProgressPublisher
extends AProgressPublisher
implements IMultiThreadProgressPublisher {
    private final Map<String, String> publishedInfos = new LinkedHashMap<String, String>();
    private final Lock lock = new ReentrantLock();

    public MultiThreadedProgressPublisher(Consumer<String> output) {
        super(output);
    }

    @Override
    public IProgressPublisher newThread(final String name, long total, IPublisherBuilder<? extends IProgressPublisher> builder) {
        Consumer<String> consumer = s -> {
            this.lock.lock();
            try {
                this.publishedInfos.put(name, (String)s);
            }
            finally {
                this.lock.unlock();
            }
            this.publishAll();
        };
        final IProgressPublisher publisher = builder.apply(consumer, total);
        return new IProgressPublisher(){

            @Override
            public void publish(long current) {
                publisher.publish(current);
                MultiThreadedProgressPublisher.this.publishAll();
            }

            @Override
            public void done() {
                MultiThreadedProgressPublisher.this.lock.lock();
                try {
                    MultiThreadedProgressPublisher.this.publishedInfos.remove(name);
                }
                finally {
                    MultiThreadedProgressPublisher.this.lock.unlock();
                }
                MultiThreadedProgressPublisher.this.publishAll();
            }
        };
    }

    @Override
    public void publish(long current) {
        this.publishAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishAll() {
        StringBuilder progress = new StringBuilder("\rTotal: ");
        this.lock.lock();
        try {
            progress.append(this.publishedInfos.size());
            progress.append(": [ ");
            for (Map.Entry<String, String> e : this.publishedInfos.entrySet()) {
                progress.append(e.getKey());
                progress.append(": ");
                progress.append(e.getValue(), 1, e.getValue().length());
                progress.append("; ");
            }
            progress.append("]");
        }
        finally {
            this.lock.unlock();
        }
        this.output.accept(progress.toString());
    }

    @Override
    public void done() {
        this.publishedInfos.clear();
        super.done();
    }
}

