/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.cli.progress;

import java.util.function.Consumer;
import org.xblackcat.sjpu.cli.progress.AProgressPublisher;

public class PercentProgressPublisher
extends AProgressPublisher {
    private final long total;
    private long lastThreshold = -1L;
    private final long permille;

    public PercentProgressPublisher(Consumer<String> output, long total) {
        super(output);
        this.total = total;
        this.permille = total / 1000L;
    }

    @Override
    public void publish(long current) {
        if (this.lastThreshold < 0L || current < this.lastThreshold || current > this.lastThreshold + this.permille) {
            this.lastThreshold = current / this.permille * this.permille;
            this.output.accept(String.format("\rProcessed %#2.1f%% of %d bytes", (double)current / (double)this.total * 100.0, this.total));
        }
    }
}

