/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.cli.reader;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.xblackcat.sjpu.cli.reader.ISource;

public abstract class ASource
implements ISource {
    private final CounterInputStream stream;

    protected ASource(InputStream in) {
        this.stream = new CounterInputStream(new BufferedInputStream(in, 0x2000000));
    }

    @Override
    public BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader((InputStream)this.stream, StandardCharsets.UTF_8));
    }

    @Override
    public long getBytesRead() {
        return this.stream.getBytesRead();
    }

    private static class CounterInputStream
    extends InputStream {
        private final InputStream in;
        private long bytesRead = 0L;

        public CounterInputStream(InputStream in) {
            this.in = in;
        }

        @Override
        public int read() throws IOException {
            int read = this.in.read();
            if (read != -1) {
                ++this.bytesRead;
            }
            return read;
        }

        public long getBytesRead() {
            return this.bytesRead;
        }
    }
}

