/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.pdftable;

import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.xblackcat.pdftable.IPDPageProvider;
import org.xblackcat.pdftable.PDInsets;
import org.xblackcat.pdftable.PDTableTextCell;

public class DefaultPDPageProvider
implements IPDPageProvider {
    private final PDRectangle pageSize;
    private final PDInsets defaultPadding;

    public DefaultPDPageProvider(PDRectangle pageSize) {
        this(pageSize, PDTableTextCell.DEFAULT_PADDING);
    }

    public DefaultPDPageProvider(PDRectangle pageSize, PDInsets padding) {
        this.pageSize = pageSize;
        this.defaultPadding = padding;
    }

    @Override
    public PDPageContentStream buildPage(PDDocument doc, int pageNum) throws IOException {
        PDPage page = new PDPage(this.pageSize);
        doc.addPage(page);
        return new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.APPEND, true, false);
    }

    @Override
    public PDInsets getDrawMargins(int pageNum) {
        return this.defaultPadding;
    }

    @Override
    public PDRectangle getPageSize(int pageNum) {
        return this.pageSize;
    }
}

