/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.pdftable;

import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.xblackcat.pdftable.PDLineStyle;

public class PDBorderStyle {
    private final boolean drawTop;
    private final boolean drawBottom;
    private final boolean drawLeft;
    private final boolean drawRight;
    private final PDLineStyle lineStyle;

    public static PDBorderStyle fullBorderOf(PDLineStyle lineStyle) {
        return new PDBorderStyle(true, true, true, true, lineStyle);
    }

    public static PDBorderStyle topBottomBorderOf(PDLineStyle lineStyle) {
        return new PDBorderStyle(true, true, false, false, lineStyle);
    }

    public static PDBorderStyle leftRightBorderOf(PDLineStyle lineStyle) {
        return new PDBorderStyle(false, false, true, true, lineStyle);
    }

    public PDBorderStyle(boolean drawTop, boolean drawBottom, boolean drawLeft, boolean drawRight, PDLineStyle lineStyle) {
        this.drawTop = drawTop;
        this.drawBottom = drawBottom;
        this.drawLeft = drawLeft;
        this.drawRight = drawRight;
        this.lineStyle = lineStyle;
    }

    public boolean isDrawTop() {
        return this.drawTop;
    }

    public boolean isDrawBottom() {
        return this.drawBottom;
    }

    public boolean isDrawLeft() {
        return this.drawLeft;
    }

    public boolean isDrawRight() {
        return this.drawRight;
    }

    public PDLineStyle getLineStyle() {
        return this.lineStyle;
    }

    public void applyToStream(PDPageContentStream stream, float x, float y, float width, float height) throws IOException {
        if (this.lineStyle != null) {
            this.lineStyle.applyToStream(stream);
        }
        stream.setLineCapStyle(2);
        if (this.drawTop) {
            stream.moveTo(x, y);
            stream.lineTo(x + width, y);
            stream.stroke();
        }
        if (this.drawBottom) {
            stream.moveTo(x, y - height);
            stream.lineTo(x + width, y - height);
            stream.stroke();
        }
        if (this.drawLeft) {
            stream.moveTo(x, y);
            stream.lineTo(x, y - height);
            stream.stroke();
        }
        if (this.drawLeft) {
            stream.moveTo(x + width, y);
            stream.lineTo(x + width, y - height);
            stream.stroke();
        }
    }
}

