/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.pdftable;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.xblackcat.pdftable.DataGroup;
import org.xblackcat.pdftable.IPDPageProvider;
import org.xblackcat.pdftable.IPDRowProvider;
import org.xblackcat.pdftable.IPDTableCell;
import org.xblackcat.pdftable.PDBorderStyle;
import org.xblackcat.pdftable.PDInsets;
import org.xblackcat.pdftable.PDStyledString;
import org.xblackcat.pdftable.PDTableColumn;
import org.xblackcat.pdftable.PDTableRowDef;
import org.xblackcat.pdftable.PDTableTextCell;

public class PDFTable {
    private final IPDPageProvider pageProvider;
    private final IPDRowProvider rowProvider;
    private final PDBorderStyle borderStyle;
    private final int headersAmount;
    private final Color background;

    public PDFTable(IPDPageProvider pageProvider, IPDRowProvider rowProvider, PDBorderStyle borderStyle, Color background) {
        this(pageProvider, rowProvider, borderStyle, background, Integer.MAX_VALUE);
    }

    public PDFTable(IPDPageProvider pageProvider, IPDRowProvider rowProvider, PDBorderStyle borderStyle, Color background, int headersAmount) {
        this.pageProvider = pageProvider;
        this.rowProvider = rowProvider;
        this.borderStyle = borderStyle;
        this.background = background;
        this.headersAmount = headersAmount;
    }

    public Drawer applyToDocument(PDDocument doc) {
        return new Drawer(doc);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static class PDRenderedRow {
        private final PDTableRowDef rowInfo;
        private final IPDTableCell[] rowCells;
        private final float rowHeight;
        private final float rowWidth;

        PDRenderedRow(PDTableRowDef rowInfo, PDTableTextCell[] rowCells, float rowHeight, float rowWidth) {
            this.rowInfo = rowInfo;
            this.rowCells = rowCells;
            this.rowHeight = rowHeight;
            this.rowWidth = rowWidth;
        }
    }

    public static class Builder {
        private final List<PDTableColumn> columns = new ArrayList<PDTableColumn>();

        private Builder() {
        }
    }

    public class Drawer {
        private final PDDocument doc;
        private PDInsets curPageDrawMargins;
        private float curPageHeight;
        private float curPageWidth;
        private int curPage = 0;
        private int curRow = 0;
        private float tableWidth = 0.0f;
        private PDPageContentStream stream = null;
        private float drawY;
        private boolean firstRowOnPage = true;
        private final Deque<PDRenderedRow> headersStack = new LinkedList<PDRenderedRow>();

        private Drawer(PDDocument doc) {
            this.doc = doc;
        }

        public void drawTable(DataGroup[] data) throws IOException {
            this.startNewPage();
            int rowInGroup = 0;
            for (DataGroup g : data) {
                this.drawGroup(g, rowInGroup++);
            }
            if (this.stream != null) {
                this.stream.close();
            }
        }

        private void startNewPage() throws IOException {
            if (this.stream != null) {
                this.stream.close();
            }
            ++this.curPage;
            this.tableWidth = 0.0f;
            this.stream = PDFTable.this.pageProvider.buildPage(this.doc, this.curPage);
            this.curPageDrawMargins = PDFTable.this.pageProvider.getDrawMargins(this.curPage);
            PDRectangle pageSize = PDFTable.this.pageProvider.getPageSize(this.curPage);
            this.curPageHeight = pageSize.getHeight();
            this.curPageWidth = pageSize.getWidth();
            this.drawY = this.curPageHeight - this.curPageDrawMargins.top;
            this.firstRowOnPage = true;
        }

        private void drawGroup(DataGroup g, int groupRowIdx) throws IOException {
            Object valueObj = g.getKey();
            PDTableRowDef rowInfo = PDFTable.this.rowProvider.getRowCellInfo(valueObj, this.headersStack.size(), groupRowIdx, this.curRow, this.curPage);
            PDRenderedRow rr = this.preRenderedRow(valueObj, rowInfo);
            if (this.firstRowOnPage) {
                this.firstRowOnPage = false;
            } else if (rr.rowHeight > this.drawY - this.curPageDrawMargins.bottom) {
                this.drawTableBorder();
                this.startNewPage();
                int i = 0;
                for (PDRenderedRow header : this.headersStack) {
                    if (i++ > PDFTable.this.headersAmount) break;
                    this.drawRow(header);
                }
            }
            this.drawRow(rr);
            ++this.curRow;
            if (this.tableWidth < rr.rowWidth) {
                this.tableWidth = rr.rowWidth;
            }
            if (ArrayUtils.isNotEmpty((Object[])g.getValues())) {
                this.headersStack.addLast(rr);
                int rowInGroup = 0;
                for (DataGroup sg : g.getValues()) {
                    this.drawGroup(sg, rowInGroup++);
                }
                if (this.headersStack.removeLast() != rr) {
                    throw new IllegalStateException("Headers stack is broken!");
                }
            }
        }

        private void drawTableBorder() throws IOException {
            if (PDFTable.this.borderStyle != null) {
                PDFTable.this.borderStyle.applyToStream(this.stream, this.curPageDrawMargins.left, this.curPageHeight - this.curPageDrawMargins.top, this.tableWidth, this.curPageHeight - this.drawY - this.curPageDrawMargins.top);
            }
        }

        private void drawRow(PDRenderedRow rr) throws IOException {
            float x = this.curPageDrawMargins.left;
            for (int i = 0; i < rr.rowCells.length; ++i) {
                IPDTableCell cell = rr.rowCells[i];
                PDTableColumn rowCelDef = rr.rowInfo.getCellDefs()[i];
                this.drawCellBackground(x, this.drawY, rowCelDef.getWidth(), rr.rowHeight, rr.rowInfo.getBackground(), rowCelDef.getBackground());
                cell.drawCell(this.stream, x, this.drawY);
                PDBorderStyle borderStyle = rowCelDef.getCellBorderStyle();
                if (borderStyle != null) {
                    borderStyle.applyToStream(this.stream, x, this.drawY, rowCelDef.getWidth(), rr.rowHeight);
                }
                x += rowCelDef.getWidth();
            }
            if (rr.rowInfo.getBorderStyle() != null) {
                rr.rowInfo.getBorderStyle().applyToStream(this.stream, this.curPageDrawMargins.left, this.drawY, rr.rowWidth, rr.rowHeight);
            }
            this.drawY -= rr.rowHeight;
        }

        private void drawCellBackground(float x, float y, float width, float height, Color rowBG, Color cellBG) throws IOException {
            Color background = cellBG != null ? cellBG : (rowBG != null ? rowBG : PDFTable.this.background);
            if (background == null) {
                return;
            }
            this.stream.setNonStrokingColor(background);
            this.stream.addRect(x, y - height, width, height);
            this.stream.fill();
        }

        private PDRenderedRow preRenderedRow(Object valueObj, PDTableRowDef rowInfo) throws IOException {
            PDTableColumn[] rowDef = rowInfo.getCellDefs();
            PDTableTextCell[] rowCells = new PDTableTextCell[rowDef.length];
            float rowHeight = 0.0f;
            float rowWidth = 0.0f;
            for (int i = 0; i < rowDef.length; ++i) {
                PDTableColumn col = rowDef[i];
                PDInsets padding = col.getPadding();
                PDStyledString value = col.getRenderer().getValue(valueObj, i, this.curRow, this.curPage);
                PDTableTextCell cell = col.getWidth() >= 0.0f ? PDTableTextCell.toFixedWidthCell(col.getTextSpacing(), padding, col.getWidth(), value) : PDTableTextCell.toCell(col.getTextSpacing(), padding, value);
                rowCells[i] = cell;
                float cellHeight = cell.getHeight();
                rowWidth += col.getWidth();
                if (!(rowHeight < cellHeight)) continue;
                rowHeight = cellHeight;
            }
            return new PDRenderedRow(rowInfo, rowCells, rowHeight, rowWidth);
        }
    }
}

