/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.pdftable;

import java.awt.Color;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.xblackcat.pdftable.PDLineCapStyle;

public class PDLineStyle {
    public static final float DEFAULT_WIDTH = 1.0f;
    private final float width;
    private final float[] pattern;
    private final float phase;
    private final Color color;
    private final PDLineCapStyle capStyle;

    public static PDLineStyle ofWidth(float width) {
        return PDLineStyle.ofColor(width, null);
    }

    public static PDLineStyle ofColor(Color color) {
        return PDLineStyle.ofColor(1.0f, color);
    }

    public static PDLineStyle ofColor(float width, Color color) {
        return PDLineStyle.ofColor(width, color, PDLineCapStyle.ButtCap);
    }

    public static PDLineStyle ofColor(float width, Color color, PDLineCapStyle capStyle) {
        return new PDLineStyle(width, color, capStyle, 0.0f, null);
    }

    public static PDLineStyle ofPattern(float phase, float ... pattern) {
        return PDLineStyle.ofPattern(null, phase, pattern);
    }

    public static PDLineStyle ofPattern(Color color, float phase, float ... pattern) {
        return PDLineStyle.ofPattern(color, PDLineCapStyle.ButtCap, phase, pattern);
    }

    public static PDLineStyle ofPattern(Color color, PDLineCapStyle capStyle, float phase, float ... pattern) {
        return new PDLineStyle(1.0f, color, capStyle, phase, pattern);
    }

    public PDLineStyle(float width, Color color, PDLineCapStyle capStyle, float phase, float ... pattern) {
        this.width = width;
        this.capStyle = capStyle;
        this.pattern = pattern;
        this.phase = phase;
        this.color = color;
    }

    public float getWidth() {
        return this.width;
    }

    public float[] getPattern() {
        return this.pattern;
    }

    public float getPhase() {
        return this.phase;
    }

    public Color getColor() {
        return this.color;
    }

    public PDLineCapStyle getCapStyle() {
        return this.capStyle;
    }

    public PDLineStyle withCap(PDLineCapStyle newStyle) {
        return new PDLineStyle(this.width, this.color, newStyle, this.phase, this.pattern);
    }

    public void applyToStream(PDPageContentStream stream) throws IOException {
        if (this.pattern != null) {
            stream.setLineDashPattern(this.pattern, this.phase);
        }
        if (this.color != null) {
            stream.setStrokingColor(this.color);
        }
        if (this.capStyle != null) {
            stream.setLineCapStyle(this.capStyle.getValue());
        }
        stream.setLineWidth(this.width);
    }
}

