/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.pdftable;

import java.awt.Color;
import java.io.IOException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.xblackcat.pdftable.APDMeasurable;
import org.xblackcat.pdftable.APDTableCell;
import org.xblackcat.pdftable.PDFUtils;
import org.xblackcat.pdftable.PDInsets;
import org.xblackcat.pdftable.PDStyledString;
import org.xblackcat.pdftable.PDTextStyle;

public class PDTableTextCell
extends APDTableCell {
    private final float textSpacing;
    private final CellLine[] lines;

    public static PDTableTextCell toFixedWidthCell(PDInsets padding, float desiredWidth, PDStyledString ... textLines) throws IOException {
        return PDTableTextCell.toFixedWidthCell(0.0f, padding, desiredWidth, textLines);
    }

    public static PDTableTextCell toFixedWidthCell(float textSpacing, float desiredWidth, PDStyledString ... textLines) throws IOException {
        return PDTableTextCell.toFixedWidthCell(textSpacing, DEFAULT_PADDING, desiredWidth, textLines);
    }

    public static PDTableTextCell toFixedWidthCell(float desiredWidth, PDStyledString ... textLines) throws IOException {
        return PDTableTextCell.toFixedWidthCell(0.0f, DEFAULT_PADDING, desiredWidth, textLines);
    }

    public static PDTableTextCell toFixedWidthCell(float textSpacing, PDInsets padding, float desiredWidth, PDStyledString ... textLines) throws IOException {
        return new PDTableTextCell(textSpacing, padding, PDFUtils.wrapLines(desiredWidth - padding.left - padding.right, textLines));
    }

    public static PDTableTextCell toCell(PDInsets padding, PDStyledString ... textLines) throws IOException {
        return PDTableTextCell.toCell(0.0f, padding, textLines);
    }

    public static PDTableTextCell toCell(float textSpacing, PDStyledString ... textLines) throws IOException {
        return PDTableTextCell.toCell(textSpacing, DEFAULT_PADDING, textLines);
    }

    public static PDTableTextCell toCell(PDStyledString ... textLines) throws IOException {
        return PDTableTextCell.toCell(0.0f, DEFAULT_PADDING, textLines);
    }

    public static PDTableTextCell toCell(float textSpacing, PDInsets padding, PDStyledString ... textLines) throws IOException {
        return new PDTableTextCell(textSpacing, padding, PDFUtils.toCell(textLines));
    }

    public PDTableTextCell(CellLine ... lines) {
        this(DEFAULT_PADDING, lines);
    }

    public PDTableTextCell(PDInsets padding, CellLine ... lines) {
        this(0.0f, padding, lines);
    }

    private PDTableTextCell(float textSpacing, PDInsets padding, CellLine ... cellLines) {
        super(padding);
        this.textSpacing = textSpacing;
        this.lines = cellLines;
    }

    @Override
    protected float measureWidth() throws IOException {
        return PDFUtils.maxWidthOf(this.lines) + this.padding.left + this.padding.right;
    }

    @Override
    protected float measureHeight() throws IOException {
        return PDFUtils.totalHeight(this.lines) + (float)(this.lines.length - 1) * this.textSpacing + this.padding.top + this.padding.bottom;
    }

    @Override
    public void drawCell(PDPageContentStream stream, float x, float y) throws IOException {
        Color c = null;
        float textSpacing = this.getTextSpacing();
        float heightOffset = y - this.getPadding().top + textSpacing;
        for (CellLine l : this.lines) {
            float lineHeight = l.getHeight();
            heightOffset -= lineHeight - textSpacing;
            float xx = x + this.getPadding().left;
            for (PDTextPart p : l.lineParts) {
                PDTextStyle textStyle = p.getStyle();
                if (!textStyle.getColor().equals(c)) {
                    c = textStyle.getColor();
                    stream.setNonStrokingColor(c);
                }
                stream.setFont(textStyle.getFont(), textStyle.getFontSize());
                stream.beginText();
                stream.newLineAtOffset(xx, heightOffset);
                stream.showText(p.getText());
                stream.endText();
                xx += p.getWidth();
            }
        }
    }

    public float getTextSpacing() {
        return this.textSpacing;
    }

    public String getText() {
        StringBuilder text = new StringBuilder();
        for (CellLine l : this.lines) {
            for (PDTextPart p : l.lineParts) {
                text.append(p.getText());
            }
            text.append('\n');
        }
        return text.toString();
    }

    public String toString() {
        return this.getText();
    }

    protected static class PDTextPart
    extends APDMeasurable {
        private final CharSequence text;
        private final PDTextStyle style;

        public PDTextPart(CharSequence text, PDTextStyle style) {
            if (style == null) {
                throw new NullPointerException("Style should be set");
            }
            this.text = text;
            this.style = style;
        }

        public String getText() {
            return this.text.toString();
        }

        public PDTextStyle getStyle() {
            return this.style;
        }

        @Override
        protected float measureWidth() throws IOException {
            Float width;
            try {
                width = Float.valueOf(this.getStyle().getFont().getStringWidth(this.text.toString()) * this.getStyle().getFontSize() / 1000.0f);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Font: " + this.getStyle().getFont().getName(), e);
            }
            return width.floatValue();
        }

        @Override
        protected float measureHeight() {
            return this.getStyle().getFont().getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * this.getStyle().getFontSize();
        }

        public String toString() {
            return this.getText();
        }

        public PDTextPart withText(CharSequence s) {
            return new PDTextPart(s, this.getStyle());
        }
    }

    protected static final class CellLine
    extends APDMeasurable {
        private final PDTextPart[] lineParts;

        protected CellLine(PDTextPart ... lineParts) {
            this.lineParts = lineParts;
        }

        @Override
        protected float measureWidth() throws IOException {
            return PDFUtils.totalWidth(this.lineParts);
        }

        @Override
        protected float measureHeight() throws IOException {
            return PDFUtils.maxHeightOf(this.lineParts);
        }

        public String toString() {
            return Stream.of(this.lineParts).map(PDTextPart::getText).collect(Collectors.joining(""));
        }
    }
}

