/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.pdftable;

import java.awt.Color;
import org.apache.pdfbox.pdmodel.font.PDFont;

public class PDTextStyle {
    private final Color color;
    private final PDFont font;
    private final float fontSize;

    public PDTextStyle(PDFont font, float fontSize) {
        this(Color.black, font, fontSize);
    }

    public PDTextStyle(Color color, PDFont font, float fontSize) {
        if (font == null) {
            throw new NullPointerException("Font should be specified");
        }
        if (fontSize <= 0.0f) {
            throw new NullPointerException("Font size should be positive number");
        }
        if (color == null) {
            throw new NullPointerException("Color should be specified");
        }
        this.color = color;
        this.font = font;
        this.fontSize = fontSize;
    }

    public Color getColor() {
        return this.color;
    }

    public PDFont getFont() {
        return this.font;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public PDTextStyle with(PDFont font) {
        return new PDTextStyle(this.getColor(), font, this.getFontSize());
    }

    public PDTextStyle with(float fontSize) {
        return new PDTextStyle(this.getColor(), this.getFont(), fontSize);
    }

    public PDTextStyle with(Color color) {
        return new PDTextStyle(color, this.getFont(), this.getFontSize());
    }
}

