/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.pdftable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.xblackcat.pdftable.IPDMeasurable;
import org.xblackcat.pdftable.PDStyledString;
import org.xblackcat.pdftable.PDTableTextCell;

public class PDFUtils {
    protected static PDTableTextCell.CellLine[] wrapLines(float desiredWidth, PDStyledString ... textLines) throws IOException {
        if (ArrayUtils.isEmpty((Object[])textLines)) {
            return new PDTableTextCell.CellLine[0];
        }
        ArrayList<PDTableTextCell.CellLine> lines = new ArrayList<PDTableTextCell.CellLine>();
        for (PDStyledString l : textLines) {
            for (PDStyledString ll : l.split('\n')) {
                lines.addAll(PDFUtils.wrapLine(desiredWidth, ll));
            }
        }
        return (PDTableTextCell.CellLine[])lines.stream().toArray(PDTableTextCell.CellLine[]::new);
    }

    protected static PDTableTextCell.CellLine[] toCell(PDStyledString ... textLines) throws IOException {
        if (ArrayUtils.isEmpty((Object[])textLines)) {
            return new PDTableTextCell.CellLine[0];
        }
        ArrayList<PDStyledString> lines = new ArrayList<PDStyledString>();
        for (PDStyledString l : textLines) {
            lines.addAll(Arrays.asList(l.split('\n')));
        }
        return (PDTableTextCell.CellLine[])lines.stream().map(PDFUtils::getParts).map(PDTableTextCell.CellLine::new).toArray(PDTableTextCell.CellLine[]::new);
    }

    protected static PDTableTextCell.PDTextPart[] getParts(PDStyledString text) {
        return (PDTableTextCell.PDTextPart[])Stream.of(text.getStyle()).map(p -> new PDTableTextCell.PDTextPart(text.getText().subSequence(p.getBeginIdx(), p.getEndIdx()), p.getStyle())).toArray(PDTableTextCell.PDTextPart[]::new);
    }

    protected static Collection<PDTableTextCell.CellLine> wrapLine(float desiredWidth, PDStyledString textLine) throws IOException {
        ArrayList<PDTableTextCell.CellLine> lines = new ArrayList<PDTableTextCell.CellLine>();
        ArrayList<PDTableTextCell.PDTextPart> currentLine = new ArrayList<PDTableTextCell.PDTextPart>();
        float offset = 0.0f;
        for (PDTableTextCell.PDTextPart p : PDFUtils.getParts(textLine)) {
            String text = p.getText();
            float stringWidth = p.getWidth();
            if (offset + stringWidth < desiredWidth) {
                currentLine.add(p);
                offset += stringWidth;
                continue;
            }
            PDTableTextCell.PDTextPart part = p;
            do {
                int partIdx;
                PDTableTextCell.PDTextPart textPart;
                int expectedIndex = Math.min((int)((float)text.length() * (desiredWidth - offset) / stringWidth), text.length());
                do {
                    int cutIdx;
                    int spaceIdx;
                    if ((spaceIdx = text.lastIndexOf(32, expectedIndex)) < 0) {
                        cutIdx = expectedIndex;
                        partIdx = expectedIndex;
                    } else {
                        cutIdx = spaceIdx;
                        partIdx = spaceIdx;
                    }
                    textPart = part.withText(text.substring(0, cutIdx));
                    --expectedIndex;
                } while (textPart.getWidth() > desiredWidth - offset);
                while (partIdx < text.length() && Character.isSpaceChar(text.charAt(partIdx))) {
                    ++partIdx;
                }
                currentLine.add(textPart);
                lines.add(new PDTableTextCell.CellLine((PDTableTextCell.PDTextPart[])currentLine.stream().toArray(PDTableTextCell.PDTextPart[]::new)));
                currentLine = new ArrayList();
                text = text.substring(partIdx);
                part = part.withText(text);
                stringWidth = part.getWidth();
                offset = 0.0f;
            } while (stringWidth > desiredWidth);
            offset = stringWidth;
            currentLine.add(part);
        }
        if (!currentLine.isEmpty()) {
            lines.add(new PDTableTextCell.CellLine((PDTableTextCell.PDTextPart[])currentLine.stream().toArray(PDTableTextCell.PDTextPart[]::new)));
        }
        return lines;
    }

    public static float maxHeightOf(IPDMeasurable ... objects) throws IOException {
        float height = 0.0f;
        for (IPDMeasurable m : objects) {
            if (!(height < m.getHeight())) continue;
            height = m.getHeight();
        }
        return height;
    }

    public static float maxWidthOf(IPDMeasurable ... objects) throws IOException {
        float width = 0.0f;
        for (IPDMeasurable m : objects) {
            if (!(width < m.getWidth())) continue;
            width = m.getWidth();
        }
        return width;
    }

    public static float totalHeight(IPDMeasurable ... objects) throws IOException {
        float height = 0.0f;
        for (IPDMeasurable m : objects) {
            height += m.getHeight();
        }
        return height;
    }

    public static float totalWidth(IPDMeasurable ... objects) throws IOException {
        float width = 0.0f;
        for (IPDMeasurable m : objects) {
            width += m.getWidth();
        }
        return width;
    }

    public static PDRectangle getRowSize(IPDMeasurable ... objects) throws IOException {
        float height = 0.0f;
        float width = 0.0f;
        for (IPDMeasurable m : objects) {
            if (height < m.getHeight()) {
                height = m.getHeight();
            }
            width += m.getWidth();
        }
        return new PDRectangle(width, height);
    }

    public static PDRectangle getColSize(IPDMeasurable ... objects) throws IOException {
        float height = 0.0f;
        float width = 0.0f;
        for (IPDMeasurable m : objects) {
            if (width < m.getWidth()) {
                width = m.getWidth();
            }
            height += m.getHeight();
        }
        return new PDRectangle(width, height);
    }
}

