/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.pdftable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.xblackcat.pdftable.PDTextStyle;

public class PDStyledString
implements CharSequence {
    private final CharSequence text;
    final StylePart[] styleParts;

    public PDStyledString(CharSequence str, PDTextStyle style) {
        this(str, new StylePart(0, str.length(), style));
    }

    private PDStyledString(CharSequence text, StylePart ... styleParts) {
        if (text == null) {
            throw new NullPointerException("String can't be null");
        }
        if (styleParts == null || styleParts.length == 0) {
            throw new IllegalArgumentException("At least one style should be specified");
        }
        this.text = text;
        this.styleParts = styleParts;
    }

    public StylePart[] getStyle() {
        return (StylePart[])this.styleParts.clone();
    }

    public String getText() {
        return this.text.toString();
    }

    @Override
    public int length() {
        return this.getText().length();
    }

    @Override
    public char charAt(int index) {
        return this.getText().charAt(index);
    }

    @Override
    public PDStyledString subSequence(int start, int end) {
        List<StylePart> styleParts = Arrays.asList(this.styleParts);
        return PDStyledString.getPdStyledSubstring(this.text, styleParts, start, end);
    }

    @Override
    public String toString() {
        return this.getText();
    }

    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(int ch, int fromIndex) {
        int max = this.text.length();
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= max) {
            return -1;
        }
        if (ch < 65536) {
            for (int i = fromIndex; i < max; ++i) {
                if (this.text.charAt(i) != ch) continue;
                return i;
            }
            return -1;
        }
        return this.indexOfSupplementary(ch, fromIndex);
    }

    private int indexOfSupplementary(int ch, int fromIndex) {
        if (Character.isValidCodePoint(ch)) {
            char hi = Character.highSurrogate(ch);
            char lo = Character.lowSurrogate(ch);
            int max = this.text.length() - 1;
            for (int i = fromIndex; i < max; ++i) {
                if (this.text.charAt(i) != hi || this.text.charAt(i + 1) != lo) continue;
                return i;
            }
        }
        return -1;
    }

    public PDStyledString[] split(char separator) {
        int separatorIdx = this.indexOf(separator);
        if (separatorIdx == -1) {
            return new PDStyledString[]{this};
        }
        ArrayList<PDStyledString> lines = new ArrayList<PDStyledString>();
        List<StylePart> styleParts = Arrays.asList(this.styleParts);
        int idxOffset = 0;
        do {
            if (idxOffset == separatorIdx + 1) continue;
            lines.add(PDStyledString.getPdStyledSubstring(this.text, styleParts, idxOffset, separatorIdx));
        } while ((separatorIdx = this.indexOf(separator, idxOffset = separatorIdx + 1)) != -1);
        if (idxOffset < this.text.length() - 1) {
            lines.add(PDStyledString.getPdStyledSubstring(this.text, styleParts, idxOffset, this.text.length()));
        }
        return (PDStyledString[])lines.stream().toArray(PDStyledString[]::new);
    }

    protected static PDStyledString getPdStyledSubstring(CharSequence string, Collection<StylePart> styleParts, int start, int end) {
        CharSequence text = string.subSequence(start, end);
        ArrayList<StylePart> newParts = new ArrayList<StylePart>();
        Iterator<StylePart> it = styleParts.iterator();
        if (it.hasNext()) {
            StylePart next;
            while ((next = it.next()).endIdx <= start && it.hasNext()) {
            }
            if (next.endIdx >= end) {
                newParts.add(new StylePart(0, end - start, next.style));
            } else {
                newParts.add(new StylePart(0, next.endIdx - start, next.style));
                while (it.hasNext() && (next = it.next()).endIdx < end) {
                    newParts.add(new StylePart(0, next.endIdx - start, next.style));
                }
                newParts.add(new StylePart(next.beginIdx - start, end - start, next.style));
            }
        }
        return new PDStyledString(text, (StylePart[])newParts.stream().toArray(StylePart[]::new));
    }

    public static final class Builder
    implements Appendable,
    CharSequence {
        final StringBuilder str = new StringBuilder();
        final List<StylePart> parts = new ArrayList<StylePart>();
        private final PDTextStyle defaultStyle;

        public Builder(PDTextStyle defaultStyle) {
            if (defaultStyle == null) {
                throw new NullPointerException("Default string style can't be null");
            }
            this.defaultStyle = defaultStyle;
        }

        @Override
        public Builder append(CharSequence csq) {
            if (csq instanceof PDStyledString) {
                return this.append((PDStyledString)csq);
            }
            return this.append(csq, this.defaultStyle);
        }

        @Override
        public Builder append(CharSequence csq, int start, int end) {
            if (csq instanceof PDStyledString) {
                return this.append((PDStyledString)csq, start, end);
            }
            return this.append(csq, this.defaultStyle, start, end);
        }

        public Builder append(CharSequence csq, PDTextStyle style) {
            return this.append(new PDStyledString(csq, style));
        }

        public Builder append(CharSequence csq, PDTextStyle style, int start, int end) {
            return this.append(new PDStyledString(csq, style), start, end);
        }

        @Override
        public Builder append(char c) {
            return this.append(c, this.defaultStyle);
        }

        public Builder append(PDStyledString csq) {
            if (csq.length() == 0) {
                return this;
            }
            int initLength = this.str.length();
            this.str.append(csq);
            if (this.parts.isEmpty()) {
                this.parts.addAll(Arrays.asList(csq.styleParts));
            } else {
                int lastIdx = this.parts.size() - 1;
                StylePart lastPart = this.parts.get(lastIdx);
                StylePart firstNewPart = csq.styleParts[0];
                if (lastPart.style.equals(firstNewPart.style)) {
                    this.parts.set(lastIdx, lastPart.enlarge(firstNewPart.endIdx));
                    Stream.of(csq.styleParts).skip(1L).map(s -> ((StylePart)s).shift(initLength)).forEachOrdered(this.parts::add);
                } else {
                    Stream.of(csq.styleParts).map(s -> ((StylePart)s).shift(initLength)).forEachOrdered(this.parts::add);
                }
            }
            return this;
        }

        public Builder append(PDStyledString csq, int start, int end) {
            return this.append(csq.subSequence(start, end));
        }

        public Builder append(char c, PDTextStyle style) {
            int initLength = this.str.length();
            this.str.append(c);
            if (this.parts.isEmpty()) {
                this.parts.add(new StylePart(0, 1, style));
            } else {
                int lastIdx = this.parts.size() - 1;
                StylePart lastPart = this.parts.get(lastIdx);
                if (lastPart.style.equals(style)) {
                    this.parts.set(lastIdx, lastPart.enlarge(1));
                } else {
                    this.parts.add(new StylePart(initLength, initLength + 1, style));
                }
            }
            return this;
        }

        public Builder clearStyle() {
            return this.setStyle(this.defaultStyle);
        }

        public Builder clearStyle(int beginIndex, int endIndex) {
            return this.setStyle(this.defaultStyle, beginIndex, endIndex);
        }

        public Builder setStyle(PDTextStyle style) {
            this.parts.clear();
            this.parts.add(new StylePart(0, this.str.length(), style));
            return this;
        }

        public Builder setStyle(PDTextStyle style, int beginIndex, int endIndex) {
            if (style == null) {
                throw new NullPointerException("Style can't be null");
            }
            if (beginIndex < 0) {
                throw new StringIndexOutOfBoundsException(beginIndex);
            }
            if (endIndex > this.str.length()) {
                throw new StringIndexOutOfBoundsException(endIndex);
            }
            int subLen = endIndex - beginIndex;
            if (subLen < 0) {
                throw new StringIndexOutOfBoundsException(subLen);
            }
            if (beginIndex == 0 && endIndex == this.str.length()) {
                return this.setStyle(style);
            }
            ArrayList<StylePart> newParts = new ArrayList<StylePart>();
            Iterator<StylePart> it = this.parts.iterator();
            StylePart p = null;
            while (it.hasNext() && beginIndex >= (p = it.next()).endIdx) {
                newParts.add(p);
            }
            if (p != null) {
                if (p.beginIdx < beginIndex) {
                    newParts.add(new StylePart(p.beginIdx, beginIndex, p.style));
                }
                newParts.add(new StylePart(beginIndex, endIndex, style));
                if (endIndex > p.endIdx) {
                    while (it.hasNext() && endIndex > (p = it.next()).endIdx) {
                    }
                }
                if (endIndex < p.endIdx) {
                    newParts.add(new StylePart(endIndex, p.endIdx, p.style));
                }
                it.forEachRemaining(newParts::add);
                this.parts.clear();
                this.parts.addAll(newParts);
            }
            return this;
        }

        @Override
        public int length() {
            return this.str.length();
        }

        @Override
        public char charAt(int index) {
            return this.str.charAt(index);
        }

        @Override
        public PDStyledString subSequence(int start, int end) {
            return PDStyledString.getPdStyledSubstring(this.str, this.parts, start, end);
        }

        public PDStyledString toStyledString() {
            ArrayList<StylePart> pp = new ArrayList<StylePart>();
            StylePart lastPart = null;
            for (StylePart p : this.parts) {
                if (lastPart == null) {
                    lastPart = p;
                    continue;
                }
                if (lastPart.style.equals(p.style)) {
                    lastPart = lastPart.setEnd(p.endIdx);
                    continue;
                }
                pp.add(lastPart);
                lastPart = p;
            }
            pp.add(lastPart);
            return new PDStyledString((CharSequence)this.str.toString(), (StylePart[])pp.stream().toArray(StylePart[]::new));
        }
    }

    public static final class StylePart {
        private final int beginIdx;
        private final int endIdx;
        private final PDTextStyle style;

        StylePart(int beginIdx, int endIdx, PDTextStyle style) {
            this.beginIdx = beginIdx;
            this.endIdx = endIdx;
            this.style = style;
        }

        private StylePart shift(int offset) {
            return new StylePart(this.beginIdx + offset, this.endIdx + offset, this.style);
        }

        public StylePart enlarge(int sizeShift) {
            return new StylePart(this.beginIdx, this.endIdx + sizeShift, this.style);
        }

        public StylePart cutHead(int idx) {
            return new StylePart(this.beginIdx, idx, this.style);
        }

        public StylePart cutTail(int idx) {
            return new StylePart(0, this.endIdx - idx, this.style);
        }

        public StylePart setEnd(int endIdx) {
            if (endIdx <= this.beginIdx) {
                throw new IllegalArgumentException("End index should be greater than begin index");
            }
            return new StylePart(this.beginIdx, endIdx, this.style);
        }

        public PDTextStyle getStyle() {
            return this.style;
        }

        public int getEndIdx() {
            return this.endIdx;
        }

        public int getBeginIdx() {
            return this.beginIdx;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StylePart stylePart = (StylePart)o;
            return this.beginIdx == stylePart.beginIdx && this.endIdx == stylePart.endIdx && Objects.equals(this.style, stylePart.style);
        }

        public int hashCode() {
            return Objects.hash(this.beginIdx, this.endIdx, this.style);
        }

        public String toString() {
            return "[" + this.beginIdx + ", " + this.endIdx + ") for style " + this.style;
        }
    }
}

