/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.pdftable;

import java.awt.Color;
import java.io.IOException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.xblackcat.pdftable.APDMeasurable;
import org.xblackcat.pdftable.APDTableCell;
import org.xblackcat.pdftable.HorizontalAlign;
import org.xblackcat.pdftable.IOffsetAdjuster;
import org.xblackcat.pdftable.PDFUtils;
import org.xblackcat.pdftable.PDInsets;
import org.xblackcat.pdftable.PDStyledString;
import org.xblackcat.pdftable.PDTextStyle;
import org.xblackcat.pdftable.VerticalAlign;

public class PDTableTextCell
extends APDTableCell {
    private final float desiredWidth;
    private final float textSpacing;
    private final CellLine[] lines;
    private final HorizontalAlign horizontalTextAlign;
    private final VerticalAlign verticalTextAlign;
    private final VerticalAlign verticalTextLineAlign;

    public static PDTableTextCell toFixedWidthCell(PDInsets padding, float desiredWidth, PDStyledString ... textLines) throws IOException {
        return PDTableTextCell.toFixedWidthCell(0.0f, padding, desiredWidth, HorizontalAlign.Left, VerticalAlign.Top, VerticalAlign.Bottom, textLines);
    }

    public static PDTableTextCell toFixedWidthCell(float textSpacing, float desiredWidth, PDStyledString ... textLines) throws IOException {
        return PDTableTextCell.toFixedWidthCell(textSpacing, DEFAULT_PADDING, desiredWidth, HorizontalAlign.Left, VerticalAlign.Bottom, VerticalAlign.Top, textLines);
    }

    public static PDTableTextCell toFixedWidthCell(float desiredWidth, PDStyledString ... textLines) throws IOException {
        return PDTableTextCell.toFixedWidthCell(0.0f, DEFAULT_PADDING, desiredWidth, HorizontalAlign.Left, VerticalAlign.Top, VerticalAlign.Bottom, textLines);
    }

    public static PDTableTextCell toFixedWidthCell(float textSpacing, PDInsets padding, float desiredWidth, HorizontalAlign horizontalTextAlign, VerticalAlign verticalTextAlign, VerticalAlign verticalTextLineAlign, PDStyledString ... textLines) throws IOException {
        return new PDTableTextCell(desiredWidth, textSpacing, padding, horizontalTextAlign, verticalTextAlign, verticalTextLineAlign, PDFUtils.wrapLines(desiredWidth - padding.left - padding.right, textLines));
    }

    public static PDTableTextCell toCell(PDInsets padding, PDStyledString ... textLines) throws IOException {
        return PDTableTextCell.toCell(0.0f, padding, HorizontalAlign.Left, VerticalAlign.Top, VerticalAlign.Bottom, textLines);
    }

    public static PDTableTextCell toCell(float textSpacing, PDStyledString ... textLines) throws IOException {
        return PDTableTextCell.toCell(textSpacing, DEFAULT_PADDING, HorizontalAlign.Left, VerticalAlign.Top, VerticalAlign.Bottom, textLines);
    }

    public static PDTableTextCell toCell(PDStyledString ... textLines) throws IOException {
        return PDTableTextCell.toCell(0.0f, DEFAULT_PADDING, HorizontalAlign.Left, VerticalAlign.Top, VerticalAlign.Bottom, textLines);
    }

    public static PDTableTextCell toCell(float textSpacing, PDInsets padding, HorizontalAlign horizontalTextAlign, VerticalAlign verticalTextAlign, VerticalAlign verticalTextLineAlign, PDStyledString ... textLines) throws IOException {
        return new PDTableTextCell(0.0f, textSpacing, padding, horizontalTextAlign, verticalTextAlign, verticalTextLineAlign, PDFUtils.toCell(textLines));
    }

    public PDTableTextCell(float desiredWidth, float textSpacing, PDInsets padding, HorizontalAlign horizontalTextAlign, VerticalAlign verticalTextAlign, VerticalAlign verticalTextLineAlign, CellLine ... cellLines) {
        super(padding);
        this.desiredWidth = desiredWidth;
        this.textSpacing = textSpacing;
        this.horizontalTextAlign = horizontalTextAlign;
        this.verticalTextAlign = verticalTextAlign;
        this.verticalTextLineAlign = verticalTextLineAlign;
        this.lines = cellLines;
    }

    @Override
    protected float measureWidth() throws IOException {
        return PDFUtils.maxWidthOf(this.lines) + this.padding.left + this.padding.right;
    }

    @Override
    protected float measureHeight() throws IOException {
        return PDFUtils.totalHeight(this.lines) + (float)(this.lines.length - 1) * this.textSpacing + this.padding.top + this.padding.bottom;
    }

    @Override
    public void drawCell(PDPageContentStream stream, float x, float y, float rowHeight) throws IOException {
        Color c = null;
        float heightOffset = y + this.getTextSpacing();
        switch (this.verticalTextAlign) {
            case Bottom: {
                heightOffset -= rowHeight - this.getHeight();
                break;
            }
            case Center: {
                heightOffset -= (rowHeight - this.getHeight()) / 2.0f;
                break;
            }
            case Top: {
                heightOffset -= this.getPadding().top;
            }
        }
        IOffsetAdjuster vOA = this.getLineVerticalOffsetAdjuster();
        IOffsetAdjuster hOA = this.getHorizontalOffsetAdjuster();
        for (CellLine l : this.lines) {
            float lineHeight = l.getHeight();
            float lineWidth = l.getWidth();
            heightOffset -= lineHeight + this.getTextSpacing();
            float xx = x + this.getPadding().left + hOA.measureOffset(this.getInnerWidth(), lineWidth);
            for (PDTextPart p : l.lineParts) {
                PDTextStyle textStyle = p.getStyle();
                if (!textStyle.getColor().equals(c)) {
                    c = textStyle.getColor();
                    stream.setNonStrokingColor(c);
                }
                stream.setFont(textStyle.getFont(), textStyle.getFontSize());
                stream.beginText();
                stream.newLineAtOffset(xx, heightOffset + vOA.measureOffset(lineHeight, p.getHeight()));
                stream.showText(p.getText());
                stream.endText();
                xx += p.getWidth();
            }
        }
    }

    protected IOffsetAdjuster getHorizontalOffsetAdjuster() {
        switch (this.horizontalTextAlign) {
            case Center: {
                return (t, i) -> (t - i) / 2.0f;
            }
            case Right: {
                return (t, i) -> t - i;
            }
        }
        return (t, i) -> 0.0f;
    }

    protected IOffsetAdjuster getLineVerticalOffsetAdjuster() {
        switch (this.verticalTextLineAlign) {
            case Top: {
                return (t, i) -> t - i;
            }
            case Center: {
                return (t, i) -> (t - i) / 2.0f;
            }
        }
        return (t, i) -> 0.0f;
    }

    public float getInnerWidth() throws IOException {
        return (this.desiredWidth == 0.0f ? this.getWidth() : this.desiredWidth) - this.getPadding().left - this.getPadding().right;
    }

    public float getTextSpacing() {
        return this.textSpacing;
    }

    public String getText() {
        StringBuilder text = new StringBuilder();
        for (CellLine l : this.lines) {
            for (PDTextPart p : l.lineParts) {
                text.append(p.getText());
            }
            text.append('\n');
        }
        return text.toString();
    }

    public String toString() {
        return this.getText();
    }

    protected static class PDTextPart
    extends APDMeasurable {
        private final CharSequence text;
        private final PDTextStyle style;

        public PDTextPart(CharSequence text, PDTextStyle style) {
            if (style == null) {
                throw new NullPointerException("Style should be set");
            }
            this.text = text;
            this.style = style;
        }

        public String getText() {
            return this.text.toString();
        }

        public PDTextStyle getStyle() {
            return this.style;
        }

        @Override
        protected float measureWidth() throws IOException {
            Float width;
            try {
                width = Float.valueOf(this.getStyle().getFont().getStringWidth(this.text.toString()) * this.getStyle().getFontSize() / 1000.0f);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Font: " + this.getStyle().getFont().getName(), e);
            }
            return width.floatValue();
        }

        @Override
        protected float measureHeight() {
            return this.getStyle().getFont().getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * this.getStyle().getFontSize();
        }

        public String toString() {
            return this.getText();
        }

        public PDTextPart withText(CharSequence s) {
            return new PDTextPart(s, this.getStyle());
        }
    }

    protected static final class CellLine
    extends APDMeasurable {
        private final PDTextPart[] lineParts;

        protected CellLine(PDTextPart ... lineParts) {
            this.lineParts = lineParts;
        }

        @Override
        protected float measureWidth() throws IOException {
            return PDFUtils.totalWidth(this.lineParts);
        }

        @Override
        protected float measureHeight() throws IOException {
            return PDFUtils.maxHeightOf(this.lineParts);
        }

        public String toString() {
            return Stream.of(this.lineParts).map(PDTextPart::getText).collect(Collectors.joining(""));
        }
    }
}

