/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.pdftable;

import java.awt.Color;
import java.io.IOException;
import org.xblackcat.pdftable.APDTableCell;
import org.xblackcat.pdftable.APDTableCellDef;
import org.xblackcat.pdftable.HorizontalAlign;
import org.xblackcat.pdftable.PDBorderStyle;
import org.xblackcat.pdftable.PDInsets;
import org.xblackcat.pdftable.PDStyledString;
import org.xblackcat.pdftable.PDTableCellTextGetter;
import org.xblackcat.pdftable.PDTableTextCell;
import org.xblackcat.pdftable.VerticalAlign;

public class PDTableTextCellDef
extends APDTableCellDef {
    private final float textSpacing;
    private final PDTableCellTextGetter textGetter;
    private final HorizontalAlign horizontalTextAlign;
    private final VerticalAlign verticalTextAlign;
    private final VerticalAlign verticalTextLineAlign;

    public PDTableTextCellDef(int idx, float width, PDInsets padding, Color background, float textSpacing, PDTableCellTextGetter textGetter, PDBorderStyle cellBorderStyle, HorizontalAlign horizontalTextAlign, VerticalAlign verticalTextAlign, VerticalAlign verticalTextLineAlign) {
        super(padding, background, width, cellBorderStyle, idx);
        this.textSpacing = textSpacing;
        this.textGetter = textGetter;
        this.horizontalTextAlign = horizontalTextAlign;
        this.verticalTextAlign = verticalTextAlign;
        this.verticalTextLineAlign = verticalTextLineAlign;
    }

    public float getTextSpacing() {
        return this.textSpacing;
    }

    public PDTableCellTextGetter getTextGetter() {
        return this.textGetter;
    }

    public HorizontalAlign getHorizontalTextAlign() {
        return this.horizontalTextAlign;
    }

    public VerticalAlign getVerticalTextAlign() {
        return this.verticalTextAlign;
    }

    @Override
    public APDTableCell buildCell(Object valueObj, int i, int curRow, int curPage) throws IOException {
        PDStyledString value = this.getTextGetter().getValue(valueObj, i, curRow, curPage);
        if (this.getWidth() >= 0.0f) {
            return PDTableTextCell.toFixedWidthCell(this.textSpacing, this.padding, this.width, this.horizontalTextAlign, this.verticalTextAlign, this.verticalTextLineAlign, value);
        }
        return PDTableTextCell.toCell(this.textSpacing, this.padding, this.horizontalTextAlign, this.verticalTextAlign, this.verticalTextLineAlign, value);
    }
}

