/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.builder;

import java.lang.reflect.Method;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtNewConstructor;
import javassist.Modifier;
import javassist.NotFoundException;
import org.xblackcat.sjpu.builder.BuilderUtils;
import org.xblackcat.sjpu.builder.IDefiner;

public class Definer<Base>
implements IDefiner {
    private final Class<? extends Base> baseClass;
    private final Class<?>[] paramClasses;
    private final ClassPool pool;

    public Definer(ClassPool pool, Class<? extends Base> baseClass, Class<?> ... paramClasses) {
        this.baseClass = baseClass;
        this.pool = pool;
        this.paramClasses = paramClasses;
    }

    @Override
    public CtClass getBaseCtClass() throws NotFoundException {
        return this.pool.get(this.baseClass.getName());
    }

    @Override
    public boolean isAssignable(Class<?> clazz) {
        return this.baseClass.isAssignableFrom(clazz);
    }

    @Override
    public boolean isImplemented(Method m) {
        try {
            Method method = this.baseClass.getDeclaredMethod(m.getName(), m.getParameterTypes());
            return !Modifier.isAbstract((int)method.getModifiers());
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    @Override
    public String getNestedClassName() {
        return this.baseClass.getSimpleName() + "Impl";
    }

    @Override
    public CtConstructor buildCtConstructor(CtClass accessHelper) throws NotFoundException, CannotCompileException {
        return CtNewConstructor.make((CtClass[])BuilderUtils.toCtClasses(this.pool, this.paramClasses), (CtClass[])BuilderUtils.EMPTY_LIST, (String)"{ super($$); }", (CtClass)accessHelper);
    }

    @Override
    public ClassPool getPool() {
        return this.pool;
    }
}

