/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.builder;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.xblackcat.sjpu.builder.BuilderUtils;
import org.xblackcat.sjpu.builder.ClassBuilder;
import org.xblackcat.sjpu.builder.GeneratorException;
import org.xblackcat.sjpu.builder.IDefiner;
import org.xblackcat.sjpu.builder.IMethodBuilder;

public class FunctionalClassBuilder<Base>
extends ClassBuilder<Base> {
    public FunctionalClassBuilder(IDefiner definerF, IMethodBuilder ... builders) {
        super(definerF, builders);
    }

    @Override
    public <T extends Base> Class<? extends T> build(Class<T> target) throws GeneratorException {
        int abstractCount = 0;
        for (Method m : target.getMethods()) {
            if (!Modifier.isAbstract(m.getModifiers())) continue;
            ++abstractCount;
        }
        for (Method m : target.getDeclaredMethods()) {
            if (Modifier.isPublic(m.getModifiers()) || !Modifier.isAbstract(m.getModifiers())) continue;
            ++abstractCount;
        }
        if (abstractCount != 1) {
            throw new GeneratorException("Only single abstract method is allowed for implementation of functional interface/class. " + BuilderUtils.getName(target) + " has " + abstractCount);
        }
        return super.build(target);
    }
}

