/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.builder;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.xblackcat.sjpu.builder.BuilderUtils;
import org.xblackcat.sjpu.builder.IMethodBuilder;

public abstract class AProxyMethodBuilder
implements IMethodBuilder {
    private final Class<?> delegateClass;

    public AProxyMethodBuilder(Class<?> delegateClass) {
        this.delegateClass = delegateClass;
    }

    public Class<?> getDelegateClass() {
        return this.delegateClass;
    }

    @Override
    public boolean isAccepted(Method m) {
        Method method = BuilderUtils.findDeclaredMethod(this.delegateClass, m);
        return method != null && !Modifier.isAbstract(m.getModifiers());
    }

    @Override
    public String requirementDescription() {
        return "implemented in " + this.delegateClass.getName();
    }
}

