/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.builder;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.xblackcat.sjpu.builder.GeneratorException;

public class BuilderUtils {
    public static final CtClass[] EMPTY_LIST = new CtClass[0];

    public static String getName(Class<?> clazz) {
        return StringUtils.replaceChars((String)BuilderUtils.checkArray(clazz), (char)'$', (char)'.');
    }

    public static String getName(Type type) {
        if (type instanceof Class) {
            return BuilderUtils.getName((Class)type);
        }
        if (type instanceof ParameterizedType) {
            StringBuilder name = new StringBuilder();
            ParameterizedType pt = (ParameterizedType)type;
            name.append(BuilderUtils.getName(pt.getRawType()));
            if (pt.getActualTypeArguments().length > 0) {
                String params = Stream.of(pt.getActualTypeArguments()).map(BuilderUtils::getName).collect(Collectors.joining(",", "<", ">"));
                name.append(params);
            }
            return name.toString();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType at = (GenericArrayType)type;
            StringBuilder name = new StringBuilder();
            name.append(BuilderUtils.getName(at.getGenericComponentType()));
            name.append("[]");
            return name.toString();
        }
        return type.toString();
    }

    protected static String checkArray(Class<?> clazz) {
        if (!clazz.isArray()) {
            return clazz.getName();
        }
        return BuilderUtils.checkArray(clazz.getComponentType()) + "[]";
    }

    public static String getName(CtClass clazz) {
        return StringUtils.replaceChars((String)clazz.getName(), (char)'$', (char)'.');
    }

    public static String getUnwrapMethodName(CtClass returnType) {
        if (!returnType.isPrimitive()) {
            throw new GeneratorException("Can't build unwrap method for non-primitive class.");
        }
        if (CtClass.booleanType.equals(returnType)) {
            return "booleanValue";
        }
        if (CtClass.byteType.equals(returnType)) {
            return "byteValue";
        }
        if (CtClass.doubleType.equals(returnType)) {
            return "doubleValue";
        }
        if (CtClass.floatType.equals(returnType)) {
            return "floatValue";
        }
        if (CtClass.intType.equals(returnType)) {
            return "intValue";
        }
        if (CtClass.longType.equals(returnType)) {
            return "longValue";
        }
        if (CtClass.shortType.equals(returnType)) {
            return "shortValue";
        }
        throw new GeneratorException("Unsupported primitive type: " + returnType);
    }

    public static CtClass[] toCtClasses(ClassPool pool, Class<?> ... classes) throws NotFoundException {
        CtClass[] ctClasses = new CtClass[classes.length];
        int classesLength = classes.length;
        for (int i = 0; i < classesLength; ++i) {
            ctClasses[i] = pool.get(BuilderUtils.getName(classes[i]));
        }
        return ctClasses;
    }

    public static CtClass toCtClass(ClassPool pool, Class<?> clazz) throws NotFoundException {
        return pool.get(BuilderUtils.getName(clazz));
    }

    public static String asIdentifier(Class<?> typeMap) {
        return StringUtils.replaceChars((String)BuilderUtils.getName(typeMap), (char)'.', (char)'_');
    }

    public static String asIdentifier(Method mm) {
        return mm.getName() + "_" + Integer.toHexString(mm.toGenericString().hashCode());
    }

    public static ClassPool getClassPool(ClassPool parent, Class<?> clazz, Class<?> ... classes) {
        ClassPool pool = new ClassPool(parent){

            public ClassLoader getClassLoader() {
                return this.parent.getClassLoader();
            }
        };
        HashSet<ClassLoader> usedLoaders = new HashSet<ClassLoader>();
        usedLoaders.add(ClassLoader.getSystemClassLoader());
        usedLoaders.add(ClassPool.class.getClassLoader());
        if (usedLoaders.add(clazz.getClassLoader())) {
            pool.appendClassPath((ClassPath)new ClassClassPath(clazz));
        }
        for (Class<?> c : classes) {
            if (!usedLoaders.add(c.getClassLoader())) continue;
            pool.appendClassPath((ClassPath)new ClassClassPath(c));
        }
        return pool;
    }

    public static Class<?> getClass(String fqn, ClassPool pool) throws ClassNotFoundException {
        return Class.forName(fqn, true, pool.getClassLoader());
    }

    public static Class<?> substituteTypeVariables(Map<TypeVariable<?>, Class<?>> map, Type typeToResolve) {
        if (typeToResolve instanceof Class) {
            return (Class)typeToResolve;
        }
        if (typeToResolve instanceof ParameterizedType) {
            return BuilderUtils.substituteTypeVariables(map, ((ParameterizedType)typeToResolve).getRawType());
        }
        if (typeToResolve instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)typeToResolve;
            Class<?> aClass = map.get(typeVariable);
            if (aClass != null) {
                return aClass;
            }
            Type[] bounds = typeVariable.getBounds();
            if (bounds.length > 0) {
                return BuilderUtils.substituteTypeVariables(map, bounds[0]);
            }
            return Object.class;
        }
        return null;
    }

    public static Map<TypeVariable<?>, Class<?>> resolveTypeVariables(Type type) {
        HashMap result = new HashMap();
        BuilderUtils.collectTypeVariables(result, type);
        HashMap map = new HashMap();
        Iterator<TypeVariable<?>> iterator = result.keySet().iterator();
        while (iterator.hasNext()) {
            Class resolvedClass;
            Type resolved;
            TypeVariable tv;
            TypeVariable key = tv = iterator.next();
            do {
                if (!((resolved = result.get(key)) instanceof TypeVariable)) continue;
                key = (TypeVariable)resolved;
            } while (resolved instanceof TypeVariable);
            if (resolved instanceof Class) {
                resolvedClass = (Class)resolved;
            } else {
                if (!(resolved instanceof ParameterizedType)) continue;
                ParameterizedType pt = (ParameterizedType)resolved;
                resolvedClass = (Class)pt.getRawType();
            }
            map.put(tv, resolvedClass);
        }
        return map;
    }

    private static void collectTypeVariables(Map<TypeVariable<?>, Type> result, Type type) {
        if (type == null) {
            return;
        }
        if (type instanceof Class) {
            Class aClass = (Class)type;
            BuilderUtils.collectTypeVariables(result, aClass.getGenericSuperclass());
            for (Type i : aClass.getGenericInterfaces()) {
                BuilderUtils.collectTypeVariables(result, i);
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type[] tArgs = pType.getActualTypeArguments();
            Type rawType = pType.getRawType();
            if (rawType instanceof Class) {
                TypeVariable<Class<T>>[] tVar = ((Class)rawType).getTypeParameters();
                if (tArgs.length == tVar.length) {
                    for (int i = 0; i < tArgs.length; ++i) {
                        result.put(tVar[i], tArgs[i]);
                    }
                }
                BuilderUtils.collectTypeVariables(result, rawType);
            }
        }
    }

    public static Method findDeclaredMethod(Class<?> root, Method m) {
        return BuilderUtils.findDeclaredMethod(root, root, m);
    }

    public static Method findDeclaredMethod(Class<?> root, Class<?> tillSuperClass, Method m) {
        try {
            return root.getDeclaredMethod(m.getName(), m.getParameterTypes());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (root.equals(tillSuperClass)) {
                return null;
            }
            Class<?> superclass = root.getSuperclass();
            if (superclass == null || superclass.equals(tillSuperClass)) {
                return null;
            }
            return BuilderUtils.findDeclaredMethod(superclass, tillSuperClass, m);
        }
    }

    public static <T extends Enum<T>> T searchForEnum(Class<T> clazz, String name) throws IllegalArgumentException {
        try {
            return Enum.valueOf(clazz, name);
        }
        catch (IllegalArgumentException e) {
            for (Enum c : (Enum[])clazz.getEnumConstants()) {
                if (!name.equalsIgnoreCase(c.name())) continue;
                return (T)c;
            }
            throw e;
        }
    }

    public static String makeFieldName(String mName) {
        if (mName.startsWith("get") && mName.length() > 3) {
            char[] fn = mName.toCharArray();
            fn[3] = Character.toLowerCase(fn[3]);
            return new String(fn, 3, fn.length - 3);
        }
        if (mName.startsWith("is") && mName.length() > 2) {
            char[] fn = mName.toCharArray();
            fn[2] = Character.toLowerCase(fn[2]);
            return new String(fn, 2, fn.length - 2);
        }
        return mName;
    }

    public static Method findGetter(Class<?> aClass, String fieldName) {
        Method m2;
        try {
            m2 = aClass.getMethod(fieldName, new Class[0]);
            if (BuilderUtils.isGetter(m2)) {
                return m2;
            }
        }
        catch (ReflectiveOperationException m2) {
            // empty catch block
        }
        try {
            m2 = aClass.getMethod("get" + StringUtils.capitalize((String)fieldName), new Class[0]);
            if (BuilderUtils.isGetter(m2)) {
                return m2;
            }
        }
        catch (ReflectiveOperationException m3) {
            // empty catch block
        }
        try {
            m2 = aClass.getMethod("is" + StringUtils.capitalize((String)fieldName), new Class[0]);
            if (BuilderUtils.isGetter(m2)) {
                return m2;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isGetter(Method m) {
        return Modifier.isPublic(m.getModifiers()) && !m.getReturnType().equals(Void.class) && !m.getReturnType().equals(Void.TYPE) && m.getParameterCount() == 0;
    }

    public static Class<?> detectTypeArgClass(Type type) {
        return BuilderUtils.detectTypeArgsClass(type, 1)[0];
    }

    public static Class<?>[] detectTypeArgsClass(Type type, int amount) {
        Type[] typeArguments;
        Class[] result = new Class[amount];
        if (type instanceof ParameterizedType && (typeArguments = ((ParameterizedType)type).getActualTypeArguments()).length == amount) {
            while (amount-- > 0) {
                Type argument = typeArguments[amount];
                if (!(argument instanceof Class)) continue;
                result[amount] = (Class)argument;
            }
        }
        return result;
    }

    public static String toJavaLiteral(String str) {
        if (str == null) {
            return "null";
        }
        return '\"' + StringEscapeUtils.escapeJava((String)str) + '\"';
    }

    @SafeVarargs
    public static <T> String toArrayJavaCode(Function<T, String> argToJava, Class<T> elementClass, T ... args) {
        return BuilderUtils.toArrayJavaCode(argToJava, elementClass, ArrayUtils.isEmpty((Object[])args) ? Collections.emptyList() : Arrays.asList(args));
    }

    public static <T> String toArrayJavaCode(Function<T, String> argToJava, Class<T> elementClass, Collection<T> list) {
        StringBuilder javaCode = new StringBuilder("new ");
        javaCode.append(BuilderUtils.getName(elementClass));
        if (list == null || list.isEmpty()) {
            javaCode.append("[0]");
        } else {
            javaCode.append("[]{");
            boolean first = true;
            for (T el : list) {
                if (first) {
                    first = false;
                } else {
                    javaCode.append(", ");
                }
                if (el != null) {
                    javaCode.append(argToJava.apply(el));
                    continue;
                }
                javaCode.append("null");
            }
            javaCode.append("}");
        }
        return javaCode.toString();
    }
}

