/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.builder;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.ArrayUtils;
import org.xblackcat.sjpu.builder.GeneratorException;
import org.xblackcat.sjpu.builder.IBuilder;
import org.xblackcat.sjpu.builder.IFactory;

public abstract class ACachedFactory<Base, CacheObj>
implements IFactory<Base> {
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();
    protected final Class<?>[] argClasses;
    protected final Map<Key, CacheObj> helpers = new HashMap<Key, CacheObj>();
    protected final IBuilder<Base> builder;

    public ACachedFactory(IBuilder<Base> builder, Class<?> ... argClasses) {
        this.argClasses = argClasses;
        this.builder = builder;
    }

    protected <T extends Base> T instantiate(Class<? extends T> builtClass, Object[] args) throws GeneratorException {
        try {
            return builtClass.getConstructor(this.argClasses).newInstance(args);
        }
        catch (InstantiationException e) {
            throw new GeneratorException("Class is not implemented", e);
        }
        catch (IllegalAccessException e) {
            throw new GeneratorException("Access helper constructor should be public", e);
        }
        catch (InvocationTargetException e) {
            throw new GeneratorException("Exception occurs in access helper constructor", e);
        }
        catch (NoSuchMethodException e) {
            throw new GeneratorException("Access helper class constructor should have the following signature: " + builtClass.getName() + "(" + ArrayUtils.toString(this.argClasses) + " arg);", e);
        }
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }

    @Override
    public void purge() {
        this.lock.writeLock().lock();
        try {
            this.helpers.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected static final class Key {
        private final Class<?> clazz;
        private final Object[] args;

        public Key(Class<?> clazz, Object[] args) {
            this.clazz = clazz;
            this.args = args;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.clazz, key.clazz) && Arrays.equals(this.args, key.args);
        }

        public int hashCode() {
            return Objects.hash(this.clazz, Arrays.hashCode(this.args));
        }
    }
}

