/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.builder;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.Modifier;
import javassist.NotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xblackcat.sjpu.builder.BuilderUtils;
import org.xblackcat.sjpu.builder.GeneratorException;
import org.xblackcat.sjpu.builder.IBuilder;
import org.xblackcat.sjpu.builder.IDefiner;
import org.xblackcat.sjpu.builder.IMethodBuilder;

public class ClassBuilder<Base>
implements IBuilder<Base> {
    private final List<IMethodBuilder> methodBuilders;
    private final IDefiner definer;
    protected final Log log = LogFactory.getLog(this.getClass());

    public ClassBuilder(IDefiner definer, IMethodBuilder ... builders) {
        this.definer = definer;
        this.methodBuilders = Arrays.asList(builders);
    }

    @Override
    public <T extends Base> Class<? extends T> build(Class<T> target) throws GeneratorException {
        try {
            try {
                Class<?> clazz = BuilderUtils.getClass(target.getName() + "$" + this.definer.getNestedClassName(), this.definer.getPool());
                if (!target.isAssignableFrom(clazz)) {
                    throw new GeneratorException(target.getName() + " already have implemented inner class " + this.definer.getNestedClassName() + " with inconsistent structure.");
                }
                Class<?> aClass = clazz;
                return aClass;
            }
            catch (ClassNotFoundException clazz) {
                CtClass accessHelper;
                if (target.isInterface()) {
                    accessHelper = this.defineCtClassByInterface(target);
                } else {
                    if (!this.definer.isAssignable(target)) {
                        throw new GeneratorException("Access helper class should have " + String.valueOf(this.definer.getBaseCtClass()) + " as super class");
                    }
                    if (Modifier.isAbstract((int)target.getModifiers())) {
                        accessHelper = this.defineCtClassByAbstract(target);
                    } else {
                        return target;
                    }
                }
                CtConstructor constructor = this.definer.buildCtConstructor(accessHelper);
                accessHelper.addConstructor(constructor);
                for (Method m : target.getMethods()) {
                    this.implementMethod(accessHelper, target, m);
                }
                HashSet<ImplementedMethod> implementedMethods = new HashSet<ImplementedMethod>();
                this.implementNonPublicMethods(target, target, accessHelper, implementedMethods);
                Class ahClass = accessHelper.toClass(target);
                return ahClass;
            }
        }
        catch (CannotCompileException | NotFoundException e) {
            throw new GeneratorException("Exception occurs while build AccessHelper", e);
        }
    }

    private void implementNonPublicMethods(Class<?> root, Class<?> target, CtClass accessHelper, Set<ImplementedMethod> implementedMethods) throws GeneratorException {
        if (target == null || target == Object.class) {
            return;
        }
        for (Method m : target.getDeclaredMethods()) {
            if (Modifier.isPublic((int)m.getModifiers())) continue;
            ImplementedMethod method = new ImplementedMethod(m.getName(), m.getParameterTypes());
            if (!Modifier.isAbstract((int)m.getModifiers())) {
                implementedMethods.add(method);
                continue;
            }
            if (!root.equals(target) && BuilderUtils.findDeclaredMethod(root, target, m) != null || !implementedMethods.add(method)) continue;
            this.implementMethod(accessHelper, target, m);
        }
        this.implementNonPublicMethods(root, target.getSuperclass(), accessHelper, implementedMethods);
    }

    private <T extends Base> CtClass defineCtClassByInterface(Class<T> target) throws NotFoundException, CannotCompileException {
        ClassPool pool = BuilderUtils.getClassPool(this.definer.getPool(), target, new Class[0]);
        pool.appendClassPath((ClassPath)new ClassClassPath(target));
        CtClass baseClass = pool.get(target.getName());
        CtClass accessHelper = baseClass.makeNestedClass(this.definer.getNestedClassName(), true);
        accessHelper.setModifiers(17);
        accessHelper.addInterface(baseClass);
        accessHelper.setSuperclass(this.definer.getBaseCtClass());
        return accessHelper;
    }

    private <T extends Base> CtClass defineCtClassByAbstract(Class<T> target) throws NotFoundException, CannotCompileException {
        ClassPool pool = BuilderUtils.getClassPool(this.definer.getPool(), target, new Class[0]);
        CtClass thisClass = pool.get(target.getName());
        CtClass accessHelper = thisClass.makeNestedClass(this.definer.getNestedClassName(), true);
        accessHelper.setModifiers(17);
        accessHelper.setSuperclass(pool.get(target.getName()));
        return accessHelper;
    }

    private void implementMethod(CtClass accessHelper, Class<?> targetClass, Method m) throws GeneratorException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Check method: " + String.valueOf(m)));
        }
        if (!Modifier.isAbstract((int)m.getModifiers())) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Method already implemented - skip it");
            }
            return;
        }
        List builders = this.methodBuilders.stream().filter(b -> b.isAccepted(m)).collect(Collectors.toList());
        if (builders.isEmpty()) {
            throw new GeneratorException("Not found builders to process method " + String.valueOf(m) + ". Method should be " + this.methodBuilders.stream().map(IMethodBuilder::requirementDescription).collect(Collectors.joining(" or ")));
        }
        if (builders.size() > 1) {
            throw new GeneratorException("Method " + String.valueOf(m) + " should meet only one of the following requirements: " + this.methodBuilders.stream().map(IMethodBuilder::requirementDescription).collect(Collectors.joining(" or ")));
        }
        try {
            ((IMethodBuilder)builders.get(0)).buildMethod(accessHelper, targetClass, m);
        }
        catch (ReflectiveOperationException | CannotCompileException | NotFoundException e) {
            throw new GeneratorException("Exception occurs while building method " + String.valueOf(m), e);
        }
        catch (GeneratorException e) {
            GeneratorException ex = new GeneratorException("Exception occurs while building method " + String.valueOf(m) + ": " + e.getMessage(), e.getCause());
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
    }

    protected static final class ImplementedMethod {
        private final String name;
        private final Class<?>[] parameters;

        public ImplementedMethod(String name, Class<?>[] parameters) {
            this.name = name;
            this.parameters = parameters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImplementedMethod that = (ImplementedMethod)o;
            return Objects.equals(this.name, that.name) && Arrays.equals(this.parameters, that.parameters);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.parameters);
        }
    }
}

