/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.settings.config;

import java.io.IOException;
import java.io.InputStream;
import javassist.ClassPool;
import org.xblackcat.sjpu.settings.SettingsException;
import org.xblackcat.sjpu.settings.config.AnInputStreamConfig;
import org.xblackcat.sjpu.settings.config.IValueGetter;

public class ResourceConfig
extends AnInputStreamConfig {
    private final String resourceName;

    public ResourceConfig(ClassPool pool, String resourceName) {
        super(pool);
        this.resourceName = resourceName;
    }

    static InputStream getInputStream(String propertiesFile) throws IOException {
        InputStream is = ResourceConfig.class.getResourceAsStream(propertiesFile);
        if (is == null) {
            is = ResourceConfig.class.getClassLoader().getResourceAsStream(propertiesFile);
        }
        return is;
    }

    @Override
    protected IValueGetter loadProperties() throws IOException, SettingsException {
        if (this.resourceName == null) {
            return null;
        }
        InputStream is = null;
        try {
            if (!this.resourceName.endsWith(".properties")) {
                is = ResourceConfig.getInputStream(this.resourceName + ".properties");
            }
            if (is == null) {
                is = ResourceConfig.getInputStream(this.resourceName);
            }
            if (is == null) {
                IValueGetter iValueGetter = null;
                return iValueGetter;
            }
            IValueGetter iValueGetter = this.loadPropertiesFromStream(is);
            return iValueGetter;
        }
        catch (IOException e) {
            throw new SettingsException("Can't load values from  resource " + this.resourceName, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    this.log.warn((Object)("Can't close stream. [" + this.resourceName + "]"), (Throwable)e);
                }
            }
        }
    }
}

