/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.settings;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import org.xblackcat.sjpu.settings.SettingsException;
import org.xblackcat.sjpu.settings.ann.SettingsSource;
import org.xblackcat.sjpu.settings.config.AConfig;
import org.xblackcat.sjpu.settings.config.DefaultConfig;
import org.xblackcat.sjpu.settings.config.EnvConfig;
import org.xblackcat.sjpu.settings.config.InputStreamConfig;
import org.xblackcat.sjpu.settings.config.JvmConfig;
import org.xblackcat.sjpu.settings.config.MultiSourceConfig;
import org.xblackcat.sjpu.util.function.SupplierEx;

public final class Config {
    private static final PoolHolder POOL_HOLDER = new PoolHolder();
    public static final AConfig Defaults = new DefaultConfig(PoolHolder.access$100(POOL_HOLDER));

    private Config() {
    }

    public static AConfig use(File file) {
        if (file == null) {
            throw new NullPointerException("File can't be null");
        }
        return new InputStreamConfig(POOL_HOLDER.pool, (SupplierEx<InputStream, IOException>)((SupplierEx)() -> InputStreamConfig.getInputStream(file)));
    }

    public static AConfig use(Path file) {
        if (file == null) {
            throw new NullPointerException("File can't be null");
        }
        return new InputStreamConfig(POOL_HOLDER.pool, (SupplierEx<InputStream, IOException>)((SupplierEx)() -> InputStreamConfig.getInputStream(file)));
    }

    public static AConfig use(URL url) {
        if (url == null) {
            throw new NullPointerException("Url should be set");
        }
        return new InputStreamConfig(POOL_HOLDER.pool, (SupplierEx<InputStream, IOException>)((SupplierEx)url::openStream));
    }

    public static AConfig use(String resourceName) {
        if (resourceName == null) {
            throw new NullPointerException("Resource name should be set");
        }
        return new InputStreamConfig(POOL_HOLDER.pool, (SupplierEx<InputStream, IOException>)((SupplierEx)() -> InputStreamConfig.buildInputStreamProvider(resourceName)));
    }

    public static AConfig useEnv() {
        return new EnvConfig(POOL_HOLDER.pool);
    }

    public static AConfig useJvm() {
        return new JvmConfig(POOL_HOLDER.pool);
    }

    public static AConfig anyOf(AConfig ... sources) {
        return new MultiSourceConfig(POOL_HOLDER.pool, sources);
    }

    public static AConfig use(Class<?> clazz) throws SettingsException {
        SettingsSource sourceAnn = clazz.getAnnotation(SettingsSource.class);
        if (sourceAnn == null) {
            throw new SettingsException("No default source is specified for " + clazz.getName() + ". Should be specified with @" + SettingsSource.class + " annotation");
        }
        return Config.use(sourceAnn.value());
    }

    public static <T> T get(Class<T> clazz) throws SettingsException {
        return Config.use(clazz).get(clazz);
    }

    private static final class PoolHolder {
        private final ClassPool pool;
        private final ClassLoader classLoader = new ClassLoader(Config.class.getClassLoader()){};

        private PoolHolder() {
            this.pool = new ClassPool(true){

                public ClassLoader getClassLoader() {
                    return classLoader;
                }
            };
            this.pool.appendClassPath((ClassPath)new ClassClassPath(AConfig.class));
        }
    }
}

