/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.settings.config;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xblackcat.sjpu.builder.BuilderUtils;
import org.xblackcat.sjpu.settings.NoPropertyException;
import org.xblackcat.sjpu.settings.NotImplementedException;
import org.xblackcat.sjpu.settings.SettingsException;
import org.xblackcat.sjpu.settings.ann.CollectionOf;
import org.xblackcat.sjpu.settings.ann.DefaultValue;
import org.xblackcat.sjpu.settings.ann.Delimiter;
import org.xblackcat.sjpu.settings.ann.GroupField;
import org.xblackcat.sjpu.settings.ann.Ignore;
import org.xblackcat.sjpu.settings.ann.MapKey;
import org.xblackcat.sjpu.settings.ann.MapValue;
import org.xblackcat.sjpu.settings.ann.Optional;
import org.xblackcat.sjpu.settings.ann.ParseWith;
import org.xblackcat.sjpu.settings.ann.PropertyName;
import org.xblackcat.sjpu.settings.ann.Splitter;
import org.xblackcat.sjpu.settings.config.IValueGetter;
import org.xblackcat.sjpu.settings.config.ParserUtils;
import org.xblackcat.sjpu.settings.converter.IParser;

public class ClassUtils {
    private static final Log log = LogFactory.getLog(ClassUtils.class);
    private static final String DEFAULT_DELIMITER = ",";
    private static final String DEFAULT_SPLITTER = ":";

    public static String buildPropertyName(String prefixName, Method m) {
        PropertyName field;
        StringBuilder propertyNameBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)prefixName)) {
            propertyNameBuilder.append(prefixName);
            propertyNameBuilder.append('.');
        }
        if ((field = m.getAnnotation(PropertyName.class)) != null && StringUtils.isNotBlank((CharSequence)field.value())) {
            propertyNameBuilder.append(field.value());
        } else {
            String fieldName = BuilderUtils.makeFieldName((String)m.getName());
            boolean onHump = true;
            for (char c : fieldName.toCharArray()) {
                if (Character.isUpperCase(c)) {
                    if (!onHump) {
                        propertyNameBuilder.append('.');
                        onHump = true;
                    }
                } else {
                    onHump = false;
                }
                propertyNameBuilder.append(Character.toLowerCase(c));
            }
        }
        return propertyNameBuilder.toString();
    }

    static <T> List<Object> buildConstructorParameters(ClassPool pool, Class<T> clazz, IValueGetter properties, String prefixName) throws SettingsException {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Method method : clazz.getMethods()) {
            if (ClassUtils.ignoreMethod(method)) continue;
            GroupField groupField = method.getAnnotation(GroupField.class);
            try {
                Object value;
                if (groupField != null) {
                    value = ClassUtils.getGroupFieldValue(pool, groupField.value(), properties, prefixName, method);
                } else {
                    String valueStr;
                    Class<?> returnType = method.getReturnType();
                    String delimiter = ClassUtils.getDelimiter(method);
                    IParser<?> parser = ClassUtils.getCustomConverter(method);
                    if (parser != null && returnType.isAssignableFrom(parser.getReturnType())) {
                        valueStr = ClassUtils.getStringValue(properties, prefixName, method);
                        try {
                            value = parser.apply(valueStr);
                        }
                        catch (RuntimeException e) {
                            throw new SettingsException("Can't parse value " + valueStr + " to type " + returnType.getName(), e);
                        }
                    }
                    if (returnType.isArray()) {
                        value = ClassUtils.getArrayFieldValue(properties, prefixName, method, delimiter, parser);
                    } else if (Collection.class.isAssignableFrom(returnType)) {
                        value = ClassUtils.getCollectionFieldValue(properties, prefixName, method, delimiter, parser);
                    } else if (Map.class.isAssignableFrom(returnType)) {
                        value = ClassUtils.getMapFieldValue(properties, prefixName, method, delimiter);
                    } else if (returnType.isInterface()) {
                        String propertyName = ClassUtils.buildPropertyName(prefixName, method);
                        Constructor<?> c = ClassUtils.getSettingsConstructor(returnType, pool);
                        value = ClassUtils.initialize(c, ClassUtils.buildConstructorParameters(pool, returnType, properties, propertyName));
                    } else {
                        valueStr = ClassUtils.getStringValue(properties, prefixName, method);
                        try {
                            value = ParserUtils.getToObjectConverter(returnType).apply(valueStr);
                        }
                        catch (RuntimeException e) {
                            throw new SettingsException("Can't parse value " + valueStr + " to type " + returnType.getName(), e);
                        }
                    }
                }
                values.add(value);
            }
            catch (NoPropertyException e) {
                if (method.getReturnType().isPrimitive() || method.getAnnotation(Optional.class) == null) {
                    throw e;
                }
                values.add(null);
            }
        }
        return values;
    }

    private static IParser<?> getCustomConverter(Method method) throws SettingsException {
        IParser<?> parser;
        ParseWith parseWith = method.getAnnotation(ParseWith.class);
        if (parseWith == null) {
            return null;
        }
        Class<IParser<?>> aClass = parseWith.value();
        try {
            aClass.getConstructor(new Class[0]);
            parser = aClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new SettingsException("Failed to instantiate converter class " + aClass, e);
        }
        catch (IllegalAccessException e) {
            throw new SettingsException("Failed to initialize converter class " + aClass, e);
        }
        catch (NoSuchMethodException e) {
            throw new SettingsException("Converter class " + aClass + " should have default public constructor", e);
        }
        return parser;
    }

    private static String getDelimiter(Method method) {
        Delimiter delimiterAnn = method.getAnnotation(Delimiter.class);
        if (delimiterAnn == null) {
            return DEFAULT_DELIMITER;
        }
        return delimiterAnn.value();
    }

    private static String getSplitter(Method method) {
        Splitter splitterAnn = method.getAnnotation(Splitter.class);
        if (splitterAnn == null) {
            return DEFAULT_SPLITTER;
        }
        return splitterAnn.value();
    }

    static synchronized <T> Constructor<T> getSettingsConstructor(Class<T> clazz, ClassPool pool) throws SettingsException {
        Class aClass;
        String implName = clazz.getName() + "$Impl";
        try {
            aClass = Class.forName(implName, true, pool.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                CtClass settingsClass = ClassUtils.buildSettingsClass(clazz, pool);
                aClass = settingsClass.toClass();
                settingsClass.detach();
            }
            catch (CannotCompileException ee) {
                throw new SettingsException("Can't initialize a constructor for generated class " + clazz.getName(), ee);
            }
        }
        Constructor<?> constructor = aClass.getConstructors()[0];
        return constructor;
    }

    private static <T> CtClass buildSettingsClass(Class<T> clazz, ClassPool pool) throws SettingsException {
        CtClass settingsClass;
        if (!clazz.isInterface()) {
            throw new SettingsException("Only annotated interfaces are supported. " + clazz.getName() + " is a class.");
        }
        try {
            CtClass settingsInterface = pool.get(clazz.getName());
            settingsClass = settingsInterface.makeNestedClass("Impl", true);
            settingsClass.addInterface(settingsInterface);
        }
        catch (NotFoundException e) {
            throw new SettingsException("Can't generate class for settings", e);
        }
        StringBuilder toStringBody = new StringBuilder();
        StringBuilder constructorBody = new StringBuilder();
        ArrayList<CtClass> constructorParameters = new ArrayList<CtClass>();
        constructorBody.append("{\n");
        toStringBody.append("{\nreturn \"");
        toStringBody.append(clazz.getSimpleName());
        toStringBody.append(" [\"");
        int idx = 1;
        for (Method m : clazz.getMethods()) {
            CtClass retType;
            String mName = m.getName();
            Class<?> returnType = m.getReturnType();
            if (m.isDefault()) {
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Ignore default method " + m + " in interface " + clazz.getName()));
                continue;
            }
            if (m.isAnnotationPresent(Ignore.class)) {
                CtClass retType2;
                try {
                    retType2 = pool.get(returnType.getName());
                }
                catch (NotFoundException e) {
                    throw new SettingsException("Somehow a class " + returnType.getName() + " can't be found", e);
                }
                try {
                    CtMethod dumbMethod = CtNewMethod.make((int)17, (CtClass)retType2, (String)mName, (CtClass[])BuilderUtils.toCtClasses((ClassPool)pool, (Class[])m.getParameterTypes()), (CtClass[])BuilderUtils.toCtClasses((ClassPool)pool, (Class[])m.getExceptionTypes()), (String)("{ throw new " + NotImplementedException.class.getName() + "(\"Method " + mName + " is excluded from generation\"); }"), (CtClass)settingsClass);
                    settingsClass.addMethod(dumbMethod);
                    continue;
                }
                catch (CannotCompileException | NotFoundException e) {
                    throw new SettingsException("Can't add a dumb method " + mName + " to generated class", e);
                }
            }
            if (m.getParameterTypes().length > 0) {
                throw new SettingsException("Method " + m.toString() + " has parameters - can't be processed as getter");
            }
            String fieldName = "__" + BuilderUtils.makeFieldName((String)mName);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Generate a field " + fieldName + " for class " + clazz.getName()));
            }
            try {
                retType = pool.get(returnType.getName());
            }
            catch (NotFoundException e) {
                throw new SettingsException("Somehow a class " + returnType.getName() + " can't be found", e);
            }
            boolean returnTypeArray = returnType.isArray();
            String returnTypeName = BuilderUtils.getName(returnType);
            try {
                CtField f = new CtField(retType, fieldName, settingsClass);
                f.setModifiers(18);
                settingsClass.addField(f);
                String body = returnTypeArray ? "{ return (" + returnTypeName + ") this." + fieldName + ".clone(); }" : "{ return this." + fieldName + "; }";
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Implement method " + clazz.getName() + "#" + mName + "() " + body.toString()));
                }
                CtMethod getter = CtNewMethod.make((int)17, (CtClass)retType, (String)mName, (CtClass[])BuilderUtils.EMPTY_LIST, (CtClass[])BuilderUtils.EMPTY_LIST, (String)body, (CtClass)settingsClass);
                settingsClass.addMethod(getter);
            }
            catch (CannotCompileException e) {
                throw new SettingsException("Can't add a field " + fieldName + " to generated class", e);
            }
            if (returnTypeArray) {
                constructorBody.append("if ($");
                constructorBody.append(idx);
                constructorBody.append(" != null) {\n");
                constructorBody.append("this.");
                constructorBody.append(fieldName);
                constructorBody.append(" = (");
                constructorBody.append(returnTypeName);
                constructorBody.append(")$");
                constructorBody.append(idx);
                constructorBody.append(".clone();\n");
                constructorBody.append("} else {\n");
                constructorBody.append("this.");
                constructorBody.append(fieldName);
                constructorBody.append(" = null;\n}\n");
            } else {
                constructorBody.append("this.");
                constructorBody.append(fieldName);
                constructorBody.append(" = $");
                constructorBody.append(idx);
                constructorBody.append(";\n");
            }
            toStringBody.append(" + \"");
            toStringBody.append(fieldName);
            toStringBody.append(" (");
            toStringBody.append(ClassUtils.buildPropertyName(null, m));
            toStringBody.append(") = \\\"\" + java.lang.String.valueOf(this.");
            toStringBody.append(fieldName);
            toStringBody.append(") + \"\\\"; \"");
            constructorParameters.add(retType);
            ++idx;
        }
        constructorBody.append("}");
        toStringBody.setLength(toStringBody.length() - 3);
        toStringBody.append("]\";\n}");
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Generated method " + clazz.getName() + "#toString() " + toStringBody.toString()));
            }
            CtMethod toString = CtNewMethod.make((int)17, (CtClass)pool.get(String.class.getName()), (String)"toString", (CtClass[])BuilderUtils.EMPTY_LIST, (CtClass[])BuilderUtils.EMPTY_LIST, (String)toStringBody.toString(), (CtClass)settingsClass);
            settingsClass.addMethod(toString);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Generated constructor " + clazz.getName() + "() " + constructorBody.toString()));
            }
            CtConstructor constructor = CtNewConstructor.make((CtClass[])constructorParameters.toArray(new CtClass[constructorParameters.size()]), (CtClass[])BuilderUtils.EMPTY_LIST, (String)constructorBody.toString(), (CtClass)settingsClass);
            settingsClass.addConstructor(constructor);
            return settingsClass;
        }
        catch (CannotCompileException e) {
            throw new SettingsException("Can't generate a constructor for generated class " + clazz.getName(), e);
        }
        catch (NotFoundException e) {
            throw new SettingsException("Can't generate toString() method for generated class " + clazz.getName(), e);
        }
    }

    static String getStringValue(IValueGetter properties, String prefixName, Method m) throws SettingsException {
        Class<?> returnType = m.getReturnType();
        String propertyName = ClassUtils.buildPropertyName(prefixName, m);
        String valueStr = properties.get(propertyName);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Property " + propertyName + " for method " + m.getName() + " is " + valueStr));
        }
        if (valueStr == null) {
            String defValue;
            DefaultValue field = m.getAnnotation(DefaultValue.class);
            boolean optional = m.isAnnotationPresent(Optional.class);
            String string = defValue = field == null ? null : field.value();
            if (StringUtils.isEmpty((CharSequence)defValue)) {
                if (returnType.isPrimitive() || !optional && defValue == null) {
                    throw new NoPropertyException(propertyName, m);
                }
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("Using default value " + defValue + " for property " + propertyName));
            }
            valueStr = defValue;
        }
        return valueStr;
    }

    private static Object getArrayFieldValue(IValueGetter properties, String prefixName, Method method, String delimiter, IParser<?> parser) throws SettingsException {
        Class<?> returnType = method.getReturnType();
        Class<?> targetType = returnType.getComponentType();
        if (parser != null && !targetType.isAssignableFrom(parser.getReturnType())) {
            throw new SettingsException("Converter return type " + parser.getReturnType().getName() + " can't be assigned to array component type" + returnType.getName());
        }
        String arrayString = ClassUtils.getStringValue(properties, prefixName, method);
        String[] values = StringUtils.splitByWholeSeparator((String)arrayString, (String)delimiter);
        if (targetType == null) {
            throw new IllegalStateException("Array component type is null? " + returnType.getName());
        }
        Object o = Array.newInstance(targetType, values.length);
        ParserUtils.ArraySetter setter = parser == null ? ParserUtils.getArraySetter(targetType) : ParserUtils.getArraySetter(parser);
        for (int i = 0; i < values.length; ++i) {
            String valueStr = values[i];
            try {
                if (valueStr == null) {
                    Array.set(o, i, null);
                    continue;
                }
                setter.set(o, i, valueStr);
                continue;
            }
            catch (RuntimeException e) {
                throw new SettingsException("Can't parse value " + valueStr + " to type " + targetType.getName(), e);
            }
        }
        return o;
    }

    private static Object getCollectionFieldValue(IValueGetter properties, String prefixName, Method method, String delimiter, IParser<?> parser) throws SettingsException {
        AbstractCollection collection;
        boolean isList;
        Class<?> proposalReturnClass;
        Class returnRawType;
        String arrayString = ClassUtils.getStringValue(properties, prefixName, method);
        if (arrayString == null) {
            return null;
        }
        if (method.getGenericReturnType() instanceof ParameterizedType) {
            ParameterizedType returnType = (ParameterizedType)method.getGenericReturnType();
            if (!(returnType.getRawType() instanceof Class)) {
                throw new SettingsException("Raw type is not a class " + returnType + " in method " + method.toString());
            }
            returnRawType = (Class)returnType.getRawType();
            proposalReturnClass = BuilderUtils.detectTypeArgClass((Type)returnType);
        } else {
            returnRawType = (Class)method.getGenericReturnType();
            proposalReturnClass = null;
        }
        CollectionOf collectionOf = method.getAnnotation(CollectionOf.class);
        Class<?> targetType = collectionOf != null ? collectionOf.value() : proposalReturnClass;
        if (proposalReturnClass != null && !targetType.isAssignableFrom(proposalReturnClass)) {
            throw new SettingsException("Specified return object " + targetType.getName() + " cannot be casted to " + proposalReturnClass.getName());
        }
        if (targetType == null) {
            throw new SettingsException("Cannot detect component type of list. Please, use @CollectionOf annotation for method " + method.toString());
        }
        if (parser != null && !targetType.isAssignableFrom(parser.getReturnType())) {
            throw new SettingsException("Converter return type " + parser.getReturnType().getName() + " can't be assigned to array component type" + targetType.getName() + " for method " + method.getName());
        }
        String[] values = StringUtils.splitByWholeSeparator((String)arrayString, (String)delimiter);
        if (returnRawType.equals(Set.class)) {
            isList = false;
            collection = Enum.class.isAssignableFrom(targetType) ? EnumSet.noneOf(targetType) : new LinkedHashSet(values.length);
        } else if (returnRawType.equals(List.class) || returnRawType.equals(List.class)) {
            isList = true;
            collection = new ArrayList(values.length);
        } else {
            throw new SettingsException("Please, specify container by interface " + Collection.class.getName() + ", " + List.class.getName() + " or " + Set.class.getName() + " as return type for collections.");
        }
        if (targetType.isInterface() || Modifier.isAbstract(targetType.getModifiers())) {
            throw new SettingsException("Only non-abstract classes could be specified as collection elements");
        }
        Function<String, Object> converter = parser == null ? ParserUtils.getToObjectConverter(targetType) : parser;
        for (String valueStr : values) {
            try {
                if (valueStr == null) {
                    collection.add(null);
                    continue;
                }
                collection.add(converter.apply(valueStr));
            }
            catch (RuntimeException e) {
                throw new SettingsException("Can't parse value " + valueStr + " to type " + targetType.getName(), e);
            }
        }
        if (isList) {
            return Collections.unmodifiableList((List)((Object)collection));
        }
        return Collections.unmodifiableSet((Set)((Object)collection));
    }

    private static Map getMapFieldValue(IValueGetter properties, String prefixName, Method method, String delimiter) throws SettingsException {
        Class<?> proposalValueClass;
        Class<?> proposalKeyClass;
        Class returnRawType;
        String arrayString = ClassUtils.getStringValue(properties, prefixName, method);
        if (arrayString == null) {
            return null;
        }
        String[] values = StringUtils.splitByWholeSeparator((String)arrayString, (String)delimiter);
        if (method.getGenericReturnType() instanceof ParameterizedType) {
            ParameterizedType returnType = (ParameterizedType)method.getGenericReturnType();
            if (!(returnType.getRawType() instanceof Class)) {
                throw new SettingsException("Raw type is not a class " + returnType + " in method " + method.toString());
            }
            returnRawType = (Class)returnType.getRawType();
            Class[] detectTypeArgsClass = BuilderUtils.detectTypeArgsClass((Type)returnType, (int)2);
            proposalKeyClass = detectTypeArgsClass[0];
            proposalValueClass = detectTypeArgsClass[1];
        } else {
            returnRawType = (Class)method.getGenericReturnType();
            proposalKeyClass = null;
            proposalValueClass = null;
        }
        if (!Map.class.equals((Object)returnRawType)) {
            throw new SettingsException("Please, specify general interface for maps as return type for method " + method.toString());
        }
        MapKey mapKey = method.getAnnotation(MapKey.class);
        Class<?> targetKeyType = mapKey != null ? mapKey.value() : proposalKeyClass;
        if (proposalKeyClass != null && !targetKeyType.isAssignableFrom(proposalKeyClass)) {
            throw new SettingsException("Specified return object " + targetKeyType.getName() + " cannot be casted to " + proposalKeyClass.getName());
        }
        if (targetKeyType == null) {
            throw new SettingsException("Cannot detect key component type of map. Please, use @MapKey annotation for method " + method.toString());
        }
        MapValue collectionOf = method.getAnnotation(MapValue.class);
        Class<?> targetValueType = collectionOf != null ? collectionOf.value() : proposalValueClass;
        if (proposalValueClass != null && !targetValueType.isAssignableFrom(proposalValueClass)) {
            throw new SettingsException("Specified return object " + targetValueType.getName() + " cannot be casted to " + proposalValueClass.getName());
        }
        if (targetValueType == null) {
            throw new SettingsException("Cannot detect value component type of map. Please, use @MapValue annotation for method " + method.toString());
        }
        AbstractMap map = Enum.class.isAssignableFrom(targetKeyType) ? new EnumMap(targetKeyType) : new LinkedHashMap(values.length);
        Function<String, ?> keyParser = ParserUtils.getToObjectConverter(targetKeyType);
        Function<String, ?> valueParser = ParserUtils.getToObjectConverter(targetValueType);
        String splitter = ClassUtils.getSplitter(method);
        for (String part : values) {
            String valueString;
            String keyString;
            String[] parts = StringUtils.splitByWholeSeparator((String)part, (String)splitter, (int)2);
            if (parts.length < 2) {
                keyString = parts[0];
                valueString = null;
            } else {
                keyString = parts[0];
                valueString = parts[1];
            }
            try {
                Object key = keyParser.apply(keyString);
                if (valueString == null) {
                    map.put(key, null);
                    continue;
                }
                map.put(key, valueParser.apply(valueString));
            }
            catch (RuntimeException e) {
                throw new SettingsException("Can't parse value " + valueString + " to type " + targetKeyType.getName(), e);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    private static <T> Map<String, T> getGroupFieldValue(ClassPool pool, Class<T> clazz, IValueGetter properties, String prefixName, Method method) throws SettingsException {
        boolean required;
        Class<?> returnType = method.getReturnType();
        if (Map.class != returnType) {
            throw new SettingsException("Group field should have Map return type");
        }
        Constructor<T> c = ClassUtils.getSettingsConstructor(clazz, pool);
        String propertyName = ClassUtils.buildPropertyName(prefixName, method);
        String propertyNameDot = propertyName + ".";
        Set propertyNames = properties.keySet().stream().filter(name -> name.startsWith(propertyNameDot)).collect(Collectors.toSet());
        HashSet<String> prefixes = new HashSet<String>();
        for (Method mm : clazz.getMethods()) {
            if (ClassUtils.ignoreMethod(mm)) continue;
            String suffix = "." + ClassUtils.buildPropertyName(null, mm);
            for (String name2 : propertyNames) {
                int cutLen;
                if (!name2.endsWith(suffix)) continue;
                int prefixLen = propertyNameDot.length();
                String prefix = prefixLen >= (cutLen = name2.length() - suffix.length()) ? "" : name2.substring(prefixLen, cutLen);
                prefixes.add(prefix);
            }
        }
        boolean bl = required = method.getAnnotation(Optional.class) == null;
        if (required && !prefixes.contains("")) {
            throw new SettingsException("A default group set is required for method " + method.getName());
        }
        HashMap<String, T> result = new HashMap<String, T>();
        for (String p : prefixes) {
            String realPrefix = StringUtils.isNotBlank((CharSequence)p) ? propertyNameDot + p : propertyName;
            result.put(p, ClassUtils.initialize(c, ClassUtils.buildConstructorParameters(pool, clazz, properties, realPrefix)));
        }
        return Collections.unmodifiableMap(result);
    }

    static <T> T initialize(Constructor<T> c, List<Object> values) throws SettingsException {
        try {
            Object[] array = values.toArray(new Object[values.size()]);
            return c.newInstance(array);
        }
        catch (InstantiationException e) {
            throw new SettingsException("Can't make a new instance of my own class :(", e);
        }
        catch (IllegalAccessException e) {
            throw new SettingsException("Can't get access to my own class :(", e);
        }
        catch (InvocationTargetException e) {
            throw new SettingsException("My class produces an exception :(", e);
        }
    }

    static <T> boolean allMethodsHaveDefaults(Class<T> clazz) {
        for (Method m : clazz.getDeclaredMethods()) {
            if (ClassUtils.ignoreMethod(m) || m.isAnnotationPresent(DefaultValue.class) || m.isAnnotationPresent(Optional.class)) continue;
            return false;
        }
        return true;
    }

    static boolean ignoreMethod(Method method) {
        return method.isDefault() || method.isAnnotationPresent(Ignore.class);
    }
}

