/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.settings.config;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Properties;
import javassist.ClassPool;
import org.xblackcat.sjpu.settings.config.AConfig;
import org.xblackcat.sjpu.settings.config.IValueGetter;
import org.xblackcat.sjpu.settings.config.MapWrapper;
import org.xblackcat.sjpu.util.function.SupplierEx;

public class InputStreamConfig
extends AConfig {
    private final SupplierEx<InputStream, IOException> inputStreamProvider;

    public InputStreamConfig(ClassPool pool, SupplierEx<InputStream, IOException> inputStreamProvider) {
        super(pool);
        this.inputStreamProvider = inputStreamProvider;
    }

    public static InputStream getInputStream(Path file) throws IOException {
        if (!Files.isReadable(file)) {
            throw new IOException("Read access denied for file " + file);
        }
        return Files.newInputStream(file, StandardOpenOption.READ);
    }

    public static InputStream buildInputStreamProvider(String resourceName) throws IOException {
        InputStream is;
        if (resourceName == null) {
            return null;
        }
        if (!resourceName.endsWith(".properties") && (is = InputStreamConfig.getInputStream(resourceName + ".properties")) != null) {
            return is;
        }
        return InputStreamConfig.getInputStream(resourceName);
    }

    public static InputStream getInputStream(String propertiesFile) throws IOException {
        InputStream is = InputStreamConfig.class.getResourceAsStream(propertiesFile);
        if (is == null) {
            is = InputStreamConfig.class.getClassLoader().getResourceAsStream(propertiesFile);
        }
        return is;
    }

    public static InputStream getInputStream(File file) throws IOException {
        if (file == null) {
            return null;
        }
        if (!file.canRead()) {
            throw new IOException("Read access denied for file " + file);
        }
        return new FileInputStream(file);
    }

    @Override
    protected final IValueGetter loadProperties() throws IOException {
        if (this.inputStreamProvider == null) {
            return null;
        }
        final LinkedHashMap<String, String> shadow = new LinkedHashMap<String, String>();
        Properties properties = new Properties(){

            @Override
            public synchronized Object put(Object key, Object value) {
                return shadow.put(Objects.toString(key, null), Objects.toString(value, null));
            }
        };
        try (InputStream in = (InputStream)this.inputStreamProvider.get();){
            if (in == null) {
                IValueGetter iValueGetter = null;
                return iValueGetter;
            }
            properties.load(new InputStreamReader((InputStream)new BufferedInputStream(in), StandardCharsets.UTF_8));
        }
        return new MapWrapper(shadow);
    }
}

