/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.settings.config;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javassist.ClassPool;
import org.apache.commons.lang3.ArrayUtils;
import org.xblackcat.sjpu.settings.config.AConfig;
import org.xblackcat.sjpu.settings.config.IValueGetter;

public class MultiSourceConfig
extends AConfig {
    private final AConfig[] sources;

    public MultiSourceConfig(ClassPool pool, AConfig ... sources) {
        super(pool);
        if (ArrayUtils.isEmpty((Object[])sources)) {
            throw new IllegalArgumentException("Please, specify at least one source");
        }
        this.sources = sources;
    }

    @Override
    protected IValueGetter loadProperties() throws IOException {
        IValueGetter[] loadedProperties = new IValueGetter[this.sources.length];
        for (int i = 0; i < this.sources.length; ++i) {
            loadedProperties[i] = this.sources[i].loadProperties();
        }
        return new MultiSourceValueGetter(loadedProperties);
    }

    private static class MultiSourceValueGetter
    implements IValueGetter {
        private final IValueGetter[] loadedProperties;
        private final Set<String> keySet = new HashSet<String>();

        public MultiSourceValueGetter(IValueGetter[] loadedProperties) {
            this.loadedProperties = loadedProperties;
        }

        @Override
        public String get(String key) {
            for (IValueGetter getter : this.loadedProperties) {
                String value;
                if (getter == null || (value = getter.get(key)) == null) continue;
                return value;
            }
            return null;
        }

        @Override
        public Set<String> keySet() {
            if (this.keySet.isEmpty()) {
                for (IValueGetter getter : this.loadedProperties) {
                    this.keySet.addAll(getter.keySet());
                }
            }
            return this.keySet;
        }
    }
}

