/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.settings;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xblackcat.sjpu.builder.BuilderUtils;
import org.xblackcat.sjpu.settings.SettingsException;
import org.xblackcat.sjpu.settings.ann.DefaultValue;
import org.xblackcat.sjpu.settings.ann.Description;
import org.xblackcat.sjpu.settings.ann.GroupField;
import org.xblackcat.sjpu.settings.ann.Ignore;
import org.xblackcat.sjpu.settings.ann.Optional;
import org.xblackcat.sjpu.settings.ann.Prefix;
import org.xblackcat.sjpu.settings.converter.IParser;
import org.xblackcat.sjpu.settings.util.ClassUtils;
import org.xblackcat.sjpu.util.function.SupplierEx;

public class Example {
    private static final Log log = LogFactory.getLog(Example.class);
    private final List<ConfigInfo<?>> infos = new ArrayList();
    private final Map<String, String> defaultValues = new HashMap<String, String>();
    private String header;
    private String footer;
    private boolean debugInfo;

    public static Example of(Class<?> clazz) {
        Example config = new Example();
        config.and(clazz);
        return config;
    }

    public static Example of(Class<?> clazz, String prefix) {
        Example config = new Example();
        config.and(clazz, prefix);
        return config;
    }

    private Example() {
    }

    public <T> Example and(Class<T> clazz) {
        Prefix prefixAnn = clazz.getAnnotation(Prefix.class);
        return this.and(clazz, prefixAnn != null ? prefixAnn.value() : "");
    }

    public <T> Example and(Class<T> clazz, String prefix) {
        this.infos.add(new ConfigInfo(clazz, prefix));
        return this;
    }

    public Example withHeader(String header) {
        this.header = header;
        return this;
    }

    public Example withFooter(String footer) {
        this.footer = footer;
        return this;
    }

    public Example withDefault(String key, String value) {
        this.defaultValues.put(key, value);
        return this;
    }

    public Example withDefault(Map<String, String> defaults) {
        this.defaultValues.putAll(defaults);
        return this;
    }

    public Example withDebugInfo() {
        this.debugInfo = true;
        return this;
    }

    public void writeTo(SupplierEx<PrintStream, IOException> printStreamSupplier) throws IOException, SettingsException {
        if (printStreamSupplier == null) {
            throw new NullPointerException("Supplier can't be null");
        }
        try (PrintStream ps = (PrintStream)printStreamSupplier.get();){
            this.writeTo(ps);
        }
    }

    public void writeTo(File file) throws IOException, SettingsException {
        if (file == null) {
            throw new NullPointerException("File can't be null");
        }
        this.writeTo((SupplierEx<PrintStream, IOException>)((SupplierEx)() -> new PrintStream(new FileOutputStream(file))));
    }

    public void saveToFile(String fileName, OpenOption ... options) throws IOException, SettingsException {
        if (fileName == null) {
            throw new NullPointerException("File name can't be null");
        }
        this.writeTo(Paths.get(fileName, new String[0]), options);
    }

    public void writeTo(Path file, OpenOption ... options) throws IOException, SettingsException {
        if (file == null) {
            throw new NullPointerException("File can't be null");
        }
        this.writeTo((SupplierEx<PrintStream, IOException>)((SupplierEx)() -> new PrintStream(Files.newOutputStream(file, options))));
    }

    public void writeTo(PrintStream printStream) throws IOException, SettingsException {
        if (printStream == null) {
            throw new NullPointerException("Print stream can't be null");
        }
        if (Example.printDescription(printStream, this.header)) {
            printStream.println();
        }
        for (ConfigInfo<?> ci : this.infos) {
            printStream.println("######");
            this.printClass(printStream, ((ConfigInfo)ci).prefix, ((ConfigInfo)ci).clazz, false);
        }
        printStream.println();
        if (Example.printDescription(printStream, this.footer)) {
            printStream.println();
        }
    }

    private void printClass(PrintStream printStream, String prefix, Class<?> clazz, boolean classIsOptional) throws SettingsException {
        Example.printDescription(printStream, this.getDescription(clazz));
        if (this.debugInfo) {
            printStream.println("#");
            printStream.print("# (debug) Interface ");
            printStream.print(BuilderUtils.getName(clazz));
            if (StringUtils.isNotBlank((CharSequence)prefix)) {
                printStream.print(" with prefix ");
                printStream.print(prefix);
            }
            printStream.println();
        }
        this.printMethods(printStream, clazz, prefix, classIsOptional);
    }

    private void printMethods(PrintStream printStream, Class<?> clazz, String prefix, boolean classIsOptional) throws SettingsException {
        for (Method m : clazz.getMethods()) {
            this.printMethod(printStream, clazz, prefix, m, classIsOptional);
        }
    }

    private void printMethod(PrintStream printStream, Class<?> clazz, String prefix, Method m, boolean classIsOptional) throws SettingsException {
        if (m.isDefault()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Ignore default method " + m + " in interface " + clazz.getName()));
            }
            return;
        }
        if (m.isAnnotationPresent(Ignore.class)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Method " + m + " is ignored by annotation in interface " + clazz.getName()));
            }
            return;
        }
        if (m.getParameterTypes().length > 0) {
            throw new SettingsException("Method " + m.toString() + " has parameters - can't be processed as getter");
        }
        printStream.println("##");
        Example.printDescription(printStream, this.getDescription(m));
        boolean optional = m.isAnnotationPresent(Optional.class);
        GroupField groupField = m.getAnnotation(GroupField.class);
        String propertyName = ClassUtils.buildPropertyName(prefix, m);
        String defaultValue = this.getDefaultValue(m);
        if (groupField != null) {
            Class<?> groupClass = groupField.value();
            printStream.print("#### ");
            printStream.print(propertyName);
            printStream.println(" group begin ####");
            if (!optional) {
                this.printClass(printStream, propertyName, groupClass, false);
            }
            this.printClass(printStream, propertyName + "[.<group name>]", groupClass, true);
            printStream.print("#### ");
            printStream.print(propertyName);
            printStream.println(" group  end  ####");
        } else {
            boolean customObject;
            Class<?> returnType = m.getReturnType();
            boolean showSplitterInfo = Map.class.equals(returnType);
            boolean showDelimiterInfo = returnType.isArray() || Collection.class.isAssignableFrom(returnType) || showSplitterInfo;
            IParser<?> parser = ClassUtils.getCustomConverter(m);
            boolean bl = customObject = parser != null && returnType.isAssignableFrom(parser.getReturnType());
            if (!customObject && returnType.isInterface() && !showSplitterInfo && !showDelimiterInfo) {
                printStream.print("#### ");
                printStream.print(propertyName);
                printStream.println(" group begin ####");
                this.printClass(printStream, propertyName, returnType, optional);
                printStream.print("#### ");
                printStream.print(propertyName);
                printStream.println(" group  end  ####");
            } else {
                String exampleValue = this.defaultValues.getOrDefault(propertyName, defaultValue);
                if (parser != null) {
                    Example.printDescription(printStream, "Value format: " + parser.formatDescription());
                }
                if (showDelimiterInfo) {
                    printStream.println("# Values delimiter: '" + ClassUtils.getDelimiter(m) + "'");
                }
                if (showSplitterInfo) {
                    printStream.println("# Key-value separator: '" + ClassUtils.getSplitter(m) + "'");
                }
                if (optional || classIsOptional) {
                    printStream.println("# (Optional)");
                }
                if (this.debugInfo) {
                    printStream.println("#");
                    printStream.print("# (debug) Method ");
                    printStream.print(BuilderUtils.getName(clazz));
                    printStream.print("#");
                    printStream.print(m.getName());
                    printStream.println("()");
                    printStream.print("# (debug) Java value type: ");
                    printStream.print(BuilderUtils.getName((Type)m.getGenericReturnType()));
                    printStream.println();
                }
                if (optional || classIsOptional) {
                    printStream.print('!');
                }
                printStream.print(propertyName);
                printStream.print('=');
                if (exampleValue != null) {
                    printStream.print(exampleValue);
                }
                printStream.println();
            }
        }
    }

    private String getDescription(AnnotatedElement e) {
        Description annotation = e.getAnnotation(Description.class);
        return annotation == null ? null : annotation.value();
    }

    private String getDefaultValue(Method e) {
        DefaultValue annotation = e.getAnnotation(DefaultValue.class);
        return annotation == null ? null : annotation.value();
    }

    private static boolean printDescription(PrintStream printStream, String header) {
        if (StringUtils.isNotBlank((CharSequence)header)) {
            for (String line : StringUtils.split((String)header, (String)"\n\r")) {
                printStream.print("# ");
                printStream.println(line);
            }
            return true;
        }
        return false;
    }

    private static class ConfigInfo<T> {
        private final Class<T> clazz;
        private final String prefix;

        private ConfigInfo(Class<T> clazz, String prefix) {
            this.clazz = clazz;
            this.prefix = prefix;
        }
    }
}

