/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.settings;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xblackcat.sjpu.settings.SettingsException;
import org.xblackcat.sjpu.settings.ann.SettingsSource;
import org.xblackcat.sjpu.settings.config.DefaultConfig;
import org.xblackcat.sjpu.settings.config.EnvConfig;
import org.xblackcat.sjpu.settings.config.IConfig;
import org.xblackcat.sjpu.settings.config.IMutableConfig;
import org.xblackcat.sjpu.settings.config.InputStreamConfig;
import org.xblackcat.sjpu.settings.config.JvmConfig;
import org.xblackcat.sjpu.settings.config.MultiSourceConfig;
import org.xblackcat.sjpu.settings.config.MutableConfig;
import org.xblackcat.sjpu.settings.util.LoadUtils;
import org.xblackcat.sjpu.util.function.SupplierEx;
import org.xblackcat.sjpu.util.thread.CustomNameThreadFactory;

public final class Config {
    private static final PoolHolder POOL_HOLDER = new PoolHolder();
    private static final SettingsWatchingDaemon WATCHING_DAEMON;
    private static final Executor notifyExecutor;
    private static final UnsupportedOperationException EXCEPTION;
    public static final IConfig Defaults;

    private static void postNotify(Runnable event) {
        notifyExecutor.execute(() -> {
            try {
                event.run();
            }
            catch (Throwable e) {
                SettingsWatchingDaemon.log.error((Object)"Failed to process notify", e);
            }
        });
    }

    private Config() {
    }

    public static IConfig use(File file) {
        if (file == null) {
            throw new NullPointerException("File can't be null");
        }
        return Config.use((SupplierEx<InputStream, IOException>)((SupplierEx)() -> LoadUtils.getInputStream(file)));
    }

    public static IConfig use(Path file) {
        if (file == null) {
            throw new NullPointerException("File can't be null");
        }
        return Config.use((SupplierEx<InputStream, IOException>)((SupplierEx)() -> LoadUtils.getInputStream(file)));
    }

    public static IConfig use(URL url) {
        if (url == null) {
            throw new NullPointerException("Url should be set");
        }
        return Config.use((SupplierEx<InputStream, IOException>)((SupplierEx)url::openStream));
    }

    public static IConfig use(String resourceName) {
        return Config.use((SupplierEx<InputStream, IOException>)((SupplierEx)() -> LoadUtils.buildInputStreamProvider(resourceName)));
    }

    public static IConfig use(SupplierEx<InputStream, IOException> inputStreamSupplier) {
        return new InputStreamConfig(POOL_HOLDER.pool, inputStreamSupplier);
    }

    public static IConfig useEnv() {
        return new EnvConfig(POOL_HOLDER.pool);
    }

    public static IConfig useJvm() {
        return new JvmConfig(POOL_HOLDER.pool);
    }

    public static IConfig anyOf(IConfig ... sources) {
        return new MultiSourceConfig(POOL_HOLDER.pool, sources);
    }

    public static IConfig use(Class<?> clazz) throws SettingsException {
        SettingsSource sourceAnn = clazz.getAnnotation(SettingsSource.class);
        if (sourceAnn == null) {
            throw new SettingsException("No default source is specified for " + clazz.getName() + ". Should be specified with @" + SettingsSource.class + " annotation");
        }
        return Config.use(sourceAnn.value());
    }

    public static <T> T get(Class<T> clazz) throws SettingsException {
        return Config.use(clazz).get(clazz);
    }

    public static IMutableConfig track(Path file) throws IOException, UnsupportedOperationException {
        if (file == null) {
            throw new NullPointerException("File can't be null");
        }
        if (EXCEPTION != null) {
            throw EXCEPTION;
        }
        return Config.WATCHING_DAEMON.watch(file);
    }

    public static IMutableConfig track(File file) throws IOException, UnsupportedOperationException {
        if (file == null) {
            throw new NullPointerException("File can't be null");
        }
        return Config.track(file.toPath());
    }

    static {
        SettingsWatchingDaemon daemon = null;
        UnsupportedOperationException ex = null;
        try {
            daemon = new SettingsWatchingDaemon();
            Thread thread = new Thread((Runnable)daemon, "Settings Watching Daemon");
            thread.setDaemon(true);
            thread.start();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        catch (UnsupportedOperationException e) {
            ex = e;
        }
        EXCEPTION = ex;
        WATCHING_DAEMON = daemon;
        notifyExecutor = new ThreadPoolExecutor(0, 15, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new CustomNameThreadFactory("notify-thread", "SettingsNotifier"));
        Defaults = new DefaultConfig(POOL_HOLDER.pool);
    }

    private static final class SettingsWatchingDaemon
    implements Runnable {
        private static final Log log = LogFactory.getLog(SettingsWatchingDaemon.class);
        private final WatchService watchService = FileSystems.getDefault().newWatchService();
        private final Map<Path, MutableConfig> trackedFiles = new WeakHashMap<Path, MutableConfig>();
        private final Map<WatchKey, List<MutableConfig>> trackers = new WeakHashMap<WatchKey, List<MutableConfig>>();
        private final ReadWriteLock lock = new ReentrantReadWriteLock();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IMutableConfig watch(Path file) throws IOException {
            this.lock.writeLock().lock();
            try {
                MutableConfig config = this.trackedFiles.get(file);
                if (config != null) {
                    MutableConfig mutableConfig = config;
                    return mutableConfig;
                }
                MutableConfig newConfig = new MutableConfig(POOL_HOLDER.pool, file, x$0 -> Config.postNotify(x$0));
                WatchKey watchKey = file.getParent().register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                this.trackers.computeIfAbsent(watchKey, k -> new ArrayList()).add(newConfig);
                this.trackedFiles.put(file, newConfig);
                MutableConfig mutableConfig = newConfig;
                return mutableConfig;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        private SettingsWatchingDaemon() throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                List<MutableConfig> configs;
                WatchKey key;
                try {
                    key = this.watchService.take();
                }
                catch (InterruptedException e) {
                    return;
                }
                if (!key.isValid()) {
                    this.lock.writeLock().lock();
                    try {
                        this.trackers.remove(key);
                    }
                    finally {
                        this.lock.writeLock().unlock();
                    }
                    continue;
                }
                this.lock.readLock().lock();
                try {
                    configs = this.trackers.get(key);
                }
                finally {
                    this.lock.readLock().unlock();
                }
                if (configs != null) {
                    HashSet<Path> paths = new HashSet<Path>();
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent.Kind<?> kind = event.kind();
                        if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                        Path filename = (Path)SettingsWatchingDaemon.getContext(event);
                        paths.add(filename);
                    }
                    for (MutableConfig c : configs) {
                        c.checkPaths(paths);
                    }
                }
                key.reset();
            }
        }

        private static <T> T getContext(WatchEvent<?> event) {
            return (T)event.context();
        }
    }

    private static final class PoolHolder {
        private final ClassPool pool;
        private final ClassLoader classLoader = new ClassLoader(Config.class.getClassLoader()){};

        private PoolHolder() {
            this.pool = new ClassPool(true){

                public ClassLoader getClassLoader() {
                    return classLoader;
                }
            };
            this.pool.appendClassPath((ClassPath)new ClassClassPath(IConfig.class));
        }
    }
}

