/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.settings.config;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.List;
import javassist.ClassPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xblackcat.sjpu.builder.BuilderUtils;
import org.xblackcat.sjpu.settings.SettingsException;
import org.xblackcat.sjpu.settings.config.IConfig;
import org.xblackcat.sjpu.settings.util.ClassUtils;
import org.xblackcat.sjpu.settings.util.IValueGetter;

abstract class APermanentConfig
implements IConfig {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final ClassPool pool;
    private IValueGetter loadedProperties;

    APermanentConfig(ClassPool pool) {
        this.pool = pool;
    }

    @Override
    public <T> T get(Class<T> clazz, String prefixName, boolean optional) throws SettingsException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Load defaults for class " + clazz.getName() + " [prefix: " + prefixName + "]"));
        }
        ClassPool pool = BuilderUtils.getClassPool((ClassPool)this.pool, clazz, (Class[])new Class[0]);
        Constructor<T> c = ClassUtils.getSettingsConstructor(clazz, pool);
        if (this.loadedProperties == null) {
            try {
                this.loadedProperties = this.loadProperties();
            }
            catch (IOException e) {
                throw new SettingsException("Can't obtain list of values for class " + clazz, e);
            }
            if (this.loadedProperties == null) {
                if (ClassUtils.allMethodsHaveDefaults(clazz)) {
                    this.loadedProperties = IValueGetter.EMPTY;
                } else {
                    if (optional) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)(clazz.getName() + " marked as optional"));
                        }
                        return null;
                    }
                    throw new SettingsException(clazz.getName() + " has mandatory properties without default values");
                }
            }
        }
        List<Object> values = ClassUtils.buildConstructorParameters(pool, clazz, prefixName, this.loadedProperties);
        return ClassUtils.initialize(c, values);
    }

    protected abstract IValueGetter loadProperties() throws IOException;
}

