/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.settings.util;

import java.lang.reflect.Array;
import java.util.function.Function;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.xblackcat.sjpu.builder.BuilderUtils;
import org.xblackcat.sjpu.settings.SettingsException;

public final class ParserUtils {
    private ParserUtils() {
    }

    static ArraySetter getArraySetter(Class<?> targetType) throws SettingsException {
        if (Object.class.isAssignableFrom(targetType)) {
            Function<String, ?> toObjectConverter = ParserUtils.getToObjectConverter(targetType);
            return ParserUtils.getArraySetter(toObjectConverter);
        }
        if (Integer.TYPE.equals(targetType)) {
            return (o, i, valueStr) -> Array.setInt(o, i, Integer.parseInt(valueStr));
        }
        if (Long.TYPE.equals(targetType)) {
            return (o, i, valueStr) -> Array.setLong(o, i, Long.parseLong(valueStr));
        }
        if (Short.TYPE.equals(targetType)) {
            return (o, i, valueStr) -> Array.setShort(o, i, Short.parseShort(valueStr));
        }
        if (Byte.TYPE.equals(targetType)) {
            return (o, i, valueStr) -> Array.setByte(o, i, Byte.parseByte(valueStr));
        }
        if (Boolean.TYPE.equals(targetType)) {
            return (o, i, valueStr) -> Array.setBoolean(o, i, BooleanUtils.toBoolean((String)valueStr));
        }
        if (Character.TYPE.equals(targetType)) {
            return (o, i, valueStr) -> Array.setChar(o, i, valueStr.toCharArray()[0]);
        }
        throw new SettingsException("Unknown type to parse: " + targetType.getName());
    }

    static ArraySetter getArraySetter(Function<String, ?> toObjectConverter) {
        return (array, index, value) -> Array.set(array, index, toObjectConverter.apply(value));
    }

    public static Function<String, ?> getToObjectConverter(Class<?> targetType) throws SettingsException {
        if (String.class.equals(targetType)) {
            return valueStr -> valueStr;
        }
        if (Integer.class.equals(targetType)) {
            return valueStr -> StringUtils.isBlank((CharSequence)valueStr) ? null : Integer.valueOf(Integer.parseInt(valueStr));
        }
        if (Integer.TYPE.equals(targetType)) {
            return Integer::parseInt;
        }
        if (Long.class.equals(targetType)) {
            return valueStr -> StringUtils.isBlank((CharSequence)valueStr) ? null : Long.valueOf(Long.parseLong(valueStr));
        }
        if (Long.TYPE.equals(targetType)) {
            return Long::parseLong;
        }
        if (Short.class.equals(targetType)) {
            return valueStr -> StringUtils.isBlank((CharSequence)valueStr) ? null : Short.valueOf(Short.parseShort(valueStr));
        }
        if (Short.TYPE.equals(targetType)) {
            return Short::parseShort;
        }
        if (Byte.class.equals(targetType)) {
            return valueStr -> StringUtils.isBlank((CharSequence)valueStr) ? null : Byte.valueOf(Byte.parseByte(valueStr));
        }
        if (Byte.TYPE.equals(targetType)) {
            return Byte::parseByte;
        }
        if (Boolean.class.equals(targetType)) {
            return valueStr -> StringUtils.isBlank((CharSequence)valueStr) ? null : Boolean.valueOf(BooleanUtils.toBoolean((String)valueStr));
        }
        if (Boolean.TYPE.equals(targetType)) {
            return BooleanUtils::toBoolean;
        }
        if (Character.class.equals(targetType)) {
            return valueStr -> StringUtils.isBlank((CharSequence)valueStr) ? null : Character.valueOf(valueStr.toCharArray()[0]);
        }
        if (Character.TYPE.equals(targetType)) {
            return valueStr -> Character.valueOf(valueStr.toCharArray()[0]);
        }
        if (Enum.class.isAssignableFrom(targetType)) {
            return valueStr -> StringUtils.isBlank((CharSequence)valueStr) ? null : BuilderUtils.searchForEnum((Class)targetType, (String)valueStr);
        }
        throw new SettingsException("Unknown type to parse: " + targetType.getName());
    }

    static interface ArraySetter {
        public void set(Object var1, int var2, String var3);
    }
}

