/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.settings.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javassist.ClassPool;
import org.apache.commons.lang3.ArrayUtils;
import org.xblackcat.sjpu.settings.config.APermanentConfig;
import org.xblackcat.sjpu.settings.config.IConfig;
import org.xblackcat.sjpu.settings.util.IValueGetter;

public class MultiSourceConfig
extends APermanentConfig {
    private final APermanentConfig[] sources;

    public MultiSourceConfig(ClassPool pool, IConfig ... sources) {
        super(pool);
        if (ArrayUtils.isEmpty((Object[])sources)) {
            throw new IllegalArgumentException("Please, specify at least one source");
        }
        this.sources = (APermanentConfig[])Arrays.stream(sources).filter(c -> c instanceof APermanentConfig).map(c -> (APermanentConfig)c).toArray(APermanentConfig[]::new);
        if (ArrayUtils.isEmpty((Object[])this.sources)) {
            throw new IllegalArgumentException("Please, specify at least one source: Mutable config is not supported");
        }
    }

    @Override
    protected IValueGetter loadProperties() throws IOException {
        ArrayList<IValueGetter> loadedProperties = new ArrayList<IValueGetter>(this.sources.length);
        for (APermanentConfig source : this.sources) {
            IValueGetter valueGetter = source.loadProperties();
            if (valueGetter == null) continue;
            loadedProperties.add(valueGetter);
        }
        return new MultiSourceValueGetter(loadedProperties);
    }

    private static class MultiSourceValueGetter
    implements IValueGetter {
        private final List<IValueGetter> loadedProperties;
        private final Set<String> keySet = new HashSet<String>();

        public MultiSourceValueGetter(List<IValueGetter> loadedProperties) {
            this.loadedProperties = loadedProperties;
        }

        @Override
        public String get(String key) {
            for (IValueGetter getter : this.loadedProperties) {
                String value = getter.get(key);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        @Override
        public Set<String> keySet() {
            if (this.keySet.isEmpty()) {
                for (IValueGetter getter : this.loadedProperties) {
                    this.keySet.addAll(getter.keySet());
                }
            }
            return this.keySet;
        }
    }
}

