/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.settings;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.UnaryOperator;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xblackcat.sjpu.settings.SettingsException;
import org.xblackcat.sjpu.settings.ann.SettingsSource;
import org.xblackcat.sjpu.settings.config.AConfig;
import org.xblackcat.sjpu.settings.config.APermanentConfig;
import org.xblackcat.sjpu.settings.config.DefaultConfig;
import org.xblackcat.sjpu.settings.config.IConfig;
import org.xblackcat.sjpu.settings.config.IMutableConfig;
import org.xblackcat.sjpu.settings.config.InputStreamConfig;
import org.xblackcat.sjpu.settings.config.MultiSourceConfig;
import org.xblackcat.sjpu.settings.config.MutableConfig;
import org.xblackcat.sjpu.settings.util.IValueGetter;
import org.xblackcat.sjpu.settings.util.LoadUtils;
import org.xblackcat.sjpu.settings.util.MapWrapper;
import org.xblackcat.sjpu.util.function.SupplierEx;
import org.xblackcat.sjpu.util.thread.CustomNameThreadFactory;

public final class Config {
    private static final PoolHolder POOL_HOLDER = new PoolHolder();
    private static final SettingsWatchingDaemon WATCHING_DAEMON;
    private static final Executor notifyExecutor;
    private static final UnsupportedOperationException EXCEPTION;
    private static final IValueGetter JVM_VALUES_GETTER;
    private static final IValueGetter ENV_VALUES_GETTER;
    public static final IConfig Defaults;

    private static void postNotify(Runnable event) {
        notifyExecutor.execute(() -> {
            try {
                event.run();
            }
            catch (Throwable e) {
                SettingsWatchingDaemon.log.error((Object)"Failed to process notify", e);
            }
        });
    }

    private Config() {
    }

    public static IConfig use(File file) {
        return Builder.defaultSettings().use(file);
    }

    public static IConfig use(Path file) {
        return Builder.defaultSettings().use(file);
    }

    public static IConfig use(URL url) {
        return Builder.defaultSettings().use(url);
    }

    public static IConfig use(String resourceName) {
        return Builder.defaultSettings().use(resourceName);
    }

    public static IConfig use(SupplierEx<InputStream, IOException> inputStreamSupplier) {
        return Builder.defaultSettings().use(inputStreamSupplier);
    }

    public static IConfig useEnv() {
        return Builder.defaultSettings().useEnv();
    }

    public static IConfig useJvm() {
        return Builder.defaultSettings().useJvm();
    }

    public static IConfig anyOf(IConfig ... sources) {
        return Builder.defaultSettings().anyOf(sources);
    }

    public static IConfig use(Class<?> clazz) throws SettingsException {
        return Builder.defaultSettings().use(Config.extractSource(clazz));
    }

    public static <T> T get(Class<T> clazz) throws SettingsException {
        return Builder.defaultSettings().use(clazz).get(clazz);
    }

    public static IMutableConfig track(Class<?> clazz) throws SettingsException, IOException, UnsupportedOperationException {
        return Builder.defaultSettings().track(Config.extractSource(clazz), clazz.getClassLoader());
    }

    public static IMutableConfig track(String resourceName) throws IOException, UnsupportedOperationException {
        return Builder.defaultSettings().track(resourceName, Config.class.getClassLoader());
    }

    public static IMutableConfig track(String resourceName, ClassLoader classLoader) throws IOException, UnsupportedOperationException {
        return Builder.defaultSettings().track(resourceName, classLoader);
    }

    public static IMutableConfig track(Path file) throws IOException, UnsupportedOperationException {
        return Builder.defaultSettings().track(file);
    }

    public static IMutableConfig track(File file) throws IOException, UnsupportedOperationException {
        if (file == null) {
            throw new NullPointerException("File can't be null");
        }
        return Config.track(file.toPath());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder with(String prefix, UnaryOperator<String> valueHandler) {
        return Config.builder().with(prefix, valueHandler);
    }

    public static Builder substitute(Map<String, String> substitution) {
        return Config.builder().substitute(substitution);
    }

    public static Builder substituteEnv() {
        return Config.builder().substituteEnv();
    }

    public static Builder substituteJvm() {
        return Config.builder().substituteJvm();
    }

    public static Builder substitute(IConfig substitution) {
        return Config.builder().substitute(substitution);
    }

    private static String extractSource(Class<?> clazz) throws SettingsException {
        SettingsSource sourceAnn = clazz.getAnnotation(SettingsSource.class);
        if (sourceAnn == null) {
            throw new SettingsException("No default source is specified for " + clazz.getName() + ". Should be specified with @" + SettingsSource.class + " annotation");
        }
        return sourceAnn.value();
    }

    static {
        JVM_VALUES_GETTER = new IValueGetter(){

            @Override
            public String get(String key) {
                return System.getProperty(key);
            }

            @Override
            public Set<String> keySet() {
                return System.getProperties().stringPropertyNames();
            }
        };
        ENV_VALUES_GETTER = LoadUtils.wrap(System.getenv());
        SettingsWatchingDaemon daemon = null;
        UnsupportedOperationException ex = null;
        try {
            daemon = new SettingsWatchingDaemon();
            Thread thread = new Thread((Runnable)daemon, "Settings Watching Daemon");
            thread.setDaemon(true);
            thread.start();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        catch (UnsupportedOperationException e) {
            ex = e;
        }
        EXCEPTION = ex;
        WATCHING_DAEMON = daemon;
        notifyExecutor = new ThreadPoolExecutor(0, 15, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new CustomNameThreadFactory("notify-thread", "SettingsNotifier"));
        Defaults = Builder.defaultSettings().defaults();
    }

    public static class Builder {
        private final Map<String, UnaryOperator<String>> prefixHandlers = new HashMap<String, UnaryOperator<String>>();
        private final List<SupplierEx<IValueGetter, SettingsException>> substitutions = new ArrayList<SupplierEx<IValueGetter, SettingsException>>();

        private static Builder defaultSettings() {
            Builder builder = new Builder();
            builder.substitutions.add((SupplierEx<IValueGetter, SettingsException>)((SupplierEx)() -> JVM_VALUES_GETTER));
            builder.substitutions.add((SupplierEx<IValueGetter, SettingsException>)((SupplierEx)() -> ENV_VALUES_GETTER));
            return builder;
        }

        public Builder with(String prefix, UnaryOperator<String> valueHandler) {
            this.prefixHandlers.put(prefix, valueHandler);
            return this;
        }

        public Builder substituteEnv() {
            this.substitutions.add((SupplierEx<IValueGetter, SettingsException>)((SupplierEx)() -> ENV_VALUES_GETTER));
            return this;
        }

        public Builder substituteJvm() {
            this.substitutions.add((SupplierEx<IValueGetter, SettingsException>)((SupplierEx)() -> JVM_VALUES_GETTER));
            return this;
        }

        public Builder substitute(Map<String, String> substitution) {
            if (substitution == null) {
                throw new NullPointerException("Substitution map is null");
            }
            if (!substitution.isEmpty()) {
                this.substitutions.add((SupplierEx<IValueGetter, SettingsException>)((SupplierEx)() -> new MapWrapper(new HashMap<String, String>(substitution))));
            }
            return this;
        }

        public Builder substitute(IConfig substitution) {
            if (!(substitution instanceof AConfig)) {
                throw new IllegalArgumentException("Unsupported config for substitution");
            }
            this.substitutions.add((SupplierEx<IValueGetter, SettingsException>)((SupplierEx)((AConfig)((Object)substitution))::getValueGetter));
            return this;
        }

        public IConfig use(File file) {
            if (file == null) {
                throw new NullPointerException("File can't be null");
            }
            return this.use((SupplierEx<InputStream, IOException>)((SupplierEx)() -> LoadUtils.getInputStream(file)));
        }

        public IConfig defaults() {
            return new DefaultConfig(POOL_HOLDER.pool, this.prefixHandlers, this.substitutions);
        }

        public IConfig use(Path file) {
            if (file == null) {
                throw new NullPointerException("File can't be null");
            }
            return this.use((SupplierEx<InputStream, IOException>)((SupplierEx)() -> LoadUtils.getInputStream(file)));
        }

        public IConfig use(URL url) {
            if (url == null) {
                throw new NullPointerException("Url should be set");
            }
            return this.use((SupplierEx<InputStream, IOException>)((SupplierEx)url::openStream));
        }

        public IConfig use(String resourceName) {
            return this.use((SupplierEx<InputStream, IOException>)((SupplierEx)() -> LoadUtils.buildInputStreamProvider(resourceName)));
        }

        public IConfig use(SupplierEx<InputStream, IOException> inputStreamSupplier) {
            return new InputStreamConfig(POOL_HOLDER.pool, this.prefixHandlers, this.substitutions, inputStreamSupplier);
        }

        public IConfig useEnv() {
            return new APermanentConfig(POOL_HOLDER.pool, this.prefixHandlers, this.substitutions){

                @Override
                protected IValueGetter loadProperties() {
                    return ENV_VALUES_GETTER;
                }
            };
        }

        public IConfig useJvm() {
            return new APermanentConfig(POOL_HOLDER.pool, this.prefixHandlers, this.substitutions){

                @Override
                protected IValueGetter loadProperties() {
                    return JVM_VALUES_GETTER;
                }
            };
        }

        public IConfig anyOf(IConfig ... sources) {
            return new MultiSourceConfig(POOL_HOLDER.pool, this.prefixHandlers, this.substitutions, sources);
        }

        public IConfig use(Class<?> clazz) throws SettingsException {
            return this.use(Config.extractSource(clazz));
        }

        public <T> T get(Class<T> clazz) throws SettingsException {
            return this.use(clazz).get(clazz);
        }

        public IMutableConfig track(Class<?> clazz) throws SettingsException, IOException, UnsupportedOperationException {
            return this.track(Config.extractSource(clazz), clazz.getClassLoader());
        }

        public IMutableConfig track(String resourceName) throws IOException, UnsupportedOperationException {
            return this.track(resourceName, Config.class.getClassLoader());
        }

        public IMutableConfig track(String resourceName, ClassLoader classLoader) throws IOException, UnsupportedOperationException {
            try {
                URL resource = classLoader.getResource(resourceName);
                if (resource == null) {
                    throw new FileNotFoundException("Resource " + resourceName + " is not found in class path");
                }
                if (!"file".equals(resource.getProtocol())) {
                    throw new IOException("Only resources as local files could be tracked.");
                }
                Path path = Paths.get(resource.toURI());
                return this.track(path);
            }
            catch (URISyntaxException e) {
                throw new IOException("Failed to get URI for the resource " + resourceName, e);
            }
        }

        public IMutableConfig track(Path file) throws IOException, UnsupportedOperationException {
            if (file == null) {
                throw new NullPointerException("File can't be null");
            }
            if (EXCEPTION != null) {
                throw EXCEPTION;
            }
            return WATCHING_DAEMON.watch(file, this.prefixHandlers, this.substitutions);
        }

        public IMutableConfig track(File file) throws IOException, UnsupportedOperationException {
            if (file == null) {
                throw new NullPointerException("File can't be null");
            }
            return this.track(file.toPath());
        }
    }

    private static final class SettingsWatchingDaemon
    implements Runnable {
        private static final Log log = LogFactory.getLog(SettingsWatchingDaemon.class);
        private final WatchService watchService = FileSystems.getDefault().newWatchService();
        private final Map<Path, MutableConfig> trackedFiles = new WeakHashMap<Path, MutableConfig>();
        private final Map<WatchKey, List<MutableConfig>> trackers = new WeakHashMap<WatchKey, List<MutableConfig>>();
        private final ReadWriteLock lock = new ReentrantReadWriteLock();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IMutableConfig watch(Path file, Map<String, UnaryOperator<String>> prefixHandler, List<SupplierEx<IValueGetter, SettingsException>> subtitution) throws IOException {
            this.lock.writeLock().lock();
            try {
                MutableConfig config = this.trackedFiles.get(file);
                if (config != null) {
                    MutableConfig mutableConfig = config;
                    return mutableConfig;
                }
                MutableConfig newConfig = new MutableConfig(POOL_HOLDER.pool, prefixHandler, subtitution, file, x$0 -> Config.postNotify(x$0));
                WatchKey watchKey = file.getParent().register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                this.trackers.computeIfAbsent(watchKey, k -> new ArrayList()).add(newConfig);
                this.trackedFiles.put(file, newConfig);
                MutableConfig mutableConfig = newConfig;
                return mutableConfig;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        private SettingsWatchingDaemon() throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                List<MutableConfig> configs;
                WatchKey key;
                try {
                    key = this.watchService.take();
                }
                catch (InterruptedException e) {
                    return;
                }
                if (!key.isValid()) {
                    this.lock.writeLock().lock();
                    try {
                        this.trackers.remove(key);
                    }
                    finally {
                        this.lock.writeLock().unlock();
                    }
                    continue;
                }
                this.lock.readLock().lock();
                try {
                    configs = this.trackers.get(key);
                }
                finally {
                    this.lock.readLock().unlock();
                }
                if (configs != null) {
                    HashSet<Path> paths = new HashSet<Path>();
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent.Kind<?> kind = event.kind();
                        if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                        Path filename = (Path)SettingsWatchingDaemon.getContext(event);
                        paths.add(filename);
                    }
                    for (MutableConfig c : configs) {
                        c.checkPaths(paths);
                    }
                }
                key.reset();
            }
        }

        private static <T> T getContext(WatchEvent<?> event) {
            return (T)event.context();
        }
    }

    private static final class PoolHolder {
        private final ClassPool pool;
        private final ClassLoader classLoader = new ClassLoader(Config.class.getClassLoader()){};

        private PoolHolder() {
            this.pool = new ClassPool(true){

                public ClassLoader getClassLoader() {
                    return classLoader;
                }
            };
            this.pool.appendClassPath((ClassPath)new ClassClassPath(IConfig.class));
        }
    }
}

