/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.settings.config;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javassist.ClassPool;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xblackcat.sjpu.builder.BuilderUtils;
import org.xblackcat.sjpu.settings.NoPropertyException;
import org.xblackcat.sjpu.settings.SettingsException;
import org.xblackcat.sjpu.settings.ann.CollectionOf;
import org.xblackcat.sjpu.settings.ann.DefaultValue;
import org.xblackcat.sjpu.settings.ann.GroupField;
import org.xblackcat.sjpu.settings.ann.MapKey;
import org.xblackcat.sjpu.settings.ann.MapValue;
import org.xblackcat.sjpu.settings.ann.Optional;
import org.xblackcat.sjpu.settings.config.ArraySetter;
import org.xblackcat.sjpu.settings.converter.IParser;
import org.xblackcat.sjpu.settings.util.ClassUtils;
import org.xblackcat.sjpu.settings.util.IValueGetter;
import org.xblackcat.sjpu.util.function.SupplierEx;

public abstract class AConfig {
    private static final Pattern VAR_EXPR = Pattern.compile("\\$\\{([\\w-.]+)}");
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final ClassPool pool;
    protected final Map<String, UnaryOperator<String>> prefixHandlers;
    protected final List<SupplierEx<IValueGetter, SettingsException>> substitutions;

    private static ArraySetter getArraySetter(Class<?> targetType) throws SettingsException {
        if (Object.class.isAssignableFrom(targetType)) {
            Function<String, ?> toObjectConverter = AConfig.getToObjectConverter(targetType);
            return AConfig.getArraySetter(toObjectConverter);
        }
        if (Integer.TYPE.equals(targetType)) {
            return (o, i, valueStr) -> Array.setInt(o, i, Integer.parseInt(valueStr));
        }
        if (Long.TYPE.equals(targetType)) {
            return (o, i, valueStr) -> Array.setLong(o, i, Long.parseLong(valueStr));
        }
        if (Short.TYPE.equals(targetType)) {
            return (o, i, valueStr) -> Array.setShort(o, i, Short.parseShort(valueStr));
        }
        if (Byte.TYPE.equals(targetType)) {
            return (o, i, valueStr) -> Array.setByte(o, i, Byte.parseByte(valueStr));
        }
        if (Boolean.TYPE.equals(targetType)) {
            return (o, i, valueStr) -> Array.setBoolean(o, i, BooleanUtils.toBoolean((String)valueStr));
        }
        if (Character.TYPE.equals(targetType)) {
            return (o, i, valueStr) -> Array.setChar(o, i, valueStr.toCharArray()[0]);
        }
        throw new SettingsException("Unknown type to parse: " + targetType.getName());
    }

    private static ArraySetter getArraySetter(Function<String, ?> toObjectConverter) {
        return (array, index, value) -> Array.set(array, index, toObjectConverter.apply(value));
    }

    private static Function<String, ?> getToObjectConverter(Class<?> targetType) throws SettingsException {
        if (String.class.equals(targetType)) {
            return valueStr -> valueStr;
        }
        if (Integer.class.equals(targetType)) {
            return valueStr -> StringUtils.isBlank((CharSequence)valueStr) ? null : Integer.valueOf(Integer.parseInt(valueStr));
        }
        if (Integer.TYPE.equals(targetType)) {
            return Integer::parseInt;
        }
        if (Long.class.equals(targetType)) {
            return valueStr -> StringUtils.isBlank((CharSequence)valueStr) ? null : Long.valueOf(Long.parseLong(valueStr));
        }
        if (Long.TYPE.equals(targetType)) {
            return Long::parseLong;
        }
        if (Short.class.equals(targetType)) {
            return valueStr -> StringUtils.isBlank((CharSequence)valueStr) ? null : Short.valueOf(Short.parseShort(valueStr));
        }
        if (Short.TYPE.equals(targetType)) {
            return Short::parseShort;
        }
        if (Byte.class.equals(targetType)) {
            return valueStr -> StringUtils.isBlank((CharSequence)valueStr) ? null : Byte.valueOf(Byte.parseByte(valueStr));
        }
        if (Byte.TYPE.equals(targetType)) {
            return Byte::parseByte;
        }
        if (Boolean.class.equals(targetType)) {
            return valueStr -> StringUtils.isBlank((CharSequence)valueStr) ? null : Boolean.valueOf(BooleanUtils.toBoolean((String)valueStr));
        }
        if (Boolean.TYPE.equals(targetType)) {
            return BooleanUtils::toBoolean;
        }
        if (Character.class.equals(targetType)) {
            return valueStr -> StringUtils.isBlank((CharSequence)valueStr) ? null : Character.valueOf(valueStr.toCharArray()[0]);
        }
        if (Character.TYPE.equals(targetType)) {
            return valueStr -> Character.valueOf(valueStr.toCharArray()[0]);
        }
        if (Enum.class.isAssignableFrom(targetType)) {
            return valueStr -> StringUtils.isBlank((CharSequence)valueStr) ? null : BuilderUtils.searchForEnum((Class)targetType, (String)valueStr);
        }
        throw new SettingsException("Unknown type to parse: " + targetType.getName());
    }

    public AConfig(ClassPool pool, Map<String, UnaryOperator<String>> prefixHandlers, List<SupplierEx<IValueGetter, SettingsException>> substitutions) {
        this.pool = pool;
        this.prefixHandlers = prefixHandlers;
        this.substitutions = substitutions;
    }

    public abstract IValueGetter getValueGetter() throws SettingsException;

    private String getStringValue(IValueGetter properties, String prefixName, Method m) throws SettingsException {
        Class<?> returnType = m.getReturnType();
        String propertyName = ClassUtils.buildPropertyName(prefixName, m);
        String valueStr = properties.get(propertyName);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Property " + propertyName + " for method " + m.getName() + " is " + valueStr));
        }
        if (valueStr == null) {
            String defValue;
            DefaultValue field = m.getAnnotation(DefaultValue.class);
            boolean optional = m.isAnnotationPresent(Optional.class);
            String string = defValue = field == null ? null : field.value();
            if (StringUtils.isEmpty((CharSequence)defValue)) {
                if (returnType.isPrimitive() || !optional && defValue == null) {
                    throw new NoPropertyException(propertyName, m);
                }
            } else if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Using default value " + defValue + " for property " + propertyName));
            }
            valueStr = defValue;
        }
        if (StringUtils.isNotBlank((CharSequence)valueStr)) {
            boolean replaced;
            HashSet<String> invalidVars = new HashSet<String>();
            do {
                replaced = false;
                Matcher matcher = VAR_EXPR.matcher(valueStr);
                StringBuffer result = new StringBuffer();
                while (matcher.find()) {
                    String varName = matcher.group(1);
                    if (Objects.equals(varName, propertyName)) {
                        throw new SettingsException("Recurrent reference to a property " + propertyName);
                    }
                    if (!invalidVars.contains(varName)) {
                        String substitution = properties.get(varName);
                        if (substitution == null) {
                            substitution = this.getSubstitution(varName);
                        }
                        if (substitution != null) {
                            matcher.appendReplacement(result, Matcher.quoteReplacement(substitution));
                            replaced = true;
                            continue;
                        }
                    }
                    invalidVars.add(varName);
                    matcher.appendReplacement(result, Matcher.quoteReplacement("${" + varName + "}"));
                }
                matcher.appendTail(result);
                if (!replaced) continue;
                valueStr = result.toString();
            } while (replaced);
        }
        if (StringUtils.isNotBlank((CharSequence)valueStr)) {
            boolean replaced;
            block2: do {
                replaced = false;
                for (Map.Entry<String, UnaryOperator<String>> h : this.prefixHandlers.entrySet()) {
                    String prefix = h.getKey();
                    if (!valueStr.startsWith(prefix)) continue;
                    valueStr = (String)h.getValue().apply(valueStr.substring(prefix.length()));
                    replaced = true;
                    continue block2;
                }
            } while (replaced);
        }
        return valueStr;
    }

    private String getSubstitution(String varName) throws SettingsException {
        if (StringUtils.isBlank((CharSequence)varName)) {
            return null;
        }
        for (SupplierEx<IValueGetter, SettingsException> vg : this.substitutions) {
            String val = ((IValueGetter)vg.get()).get(varName);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    protected <T> List<Object> buildConstructorParameters(ClassPool pool, Class<T> clazz, String prefixName, IValueGetter properties) throws SettingsException {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Method method : clazz.getMethods()) {
            if (ClassUtils.ignoreMethod(method)) continue;
            GroupField groupField = method.getAnnotation(GroupField.class);
            try {
                Object value;
                if (groupField != null) {
                    value = this.getGroupFieldValue(pool, groupField.value(), properties, prefixName, method);
                } else {
                    String valueStr;
                    Class<?> returnType = method.getReturnType();
                    String delimiter = ClassUtils.getDelimiter(method);
                    IParser<?> parser = ClassUtils.getCustomConverter(method);
                    if (parser != null && returnType.isAssignableFrom(parser.getReturnType())) {
                        valueStr = this.getStringValue(properties, prefixName, method);
                        if (valueStr != null) {
                            try {
                                value = parser.apply(valueStr);
                            }
                            catch (RuntimeException e) {
                                throw new SettingsException("Can't parse value " + valueStr + " to type " + returnType.getName(), e);
                            }
                        } else {
                            value = null;
                        }
                    } else if (returnType.isArray()) {
                        value = this.getArrayFieldValue(properties, prefixName, method, delimiter, parser);
                    } else if (Collection.class.isAssignableFrom(returnType)) {
                        value = this.getCollectionFieldValue(properties, prefixName, method, delimiter, parser);
                    } else if (Map.class.isAssignableFrom(returnType)) {
                        value = this.getMapFieldValue(properties, prefixName, method, delimiter);
                    } else if (returnType.isInterface()) {
                        String propertyName = ClassUtils.buildPropertyName(prefixName, method);
                        Constructor<?> c = ClassUtils.getSettingsConstructor(returnType, pool);
                        value = ClassUtils.initialize(c, this.buildConstructorParameters(pool, returnType, propertyName, properties));
                    } else {
                        valueStr = this.getStringValue(properties, prefixName, method);
                        if (valueStr != null) {
                            try {
                                value = AConfig.getToObjectConverter(returnType).apply(valueStr);
                            }
                            catch (RuntimeException e) {
                                throw new SettingsException("Can't parse value " + valueStr + " to type " + returnType.getName(), e);
                            }
                        } else {
                            value = null;
                        }
                    }
                }
                values.add(value);
            }
            catch (NoPropertyException e) {
                if (method.getReturnType().isPrimitive() || method.getAnnotation(Optional.class) == null) {
                    throw e;
                }
                values.add(null);
            }
        }
        return values;
    }

    private Object getArrayFieldValue(IValueGetter properties, String prefixName, Method method, String delimiter, IParser<?> parser) throws SettingsException {
        Class<?> returnType = method.getReturnType();
        Class<?> targetType = returnType.getComponentType();
        if (parser != null && !targetType.isAssignableFrom(parser.getReturnType())) {
            throw new SettingsException("Converter return type " + parser.getReturnType().getName() + " can't be assigned to array component type" + returnType.getName());
        }
        String arrayString = this.getStringValue(properties, prefixName, method);
        if (targetType == null) {
            throw new IllegalStateException("Array component type is null? " + returnType.getName());
        }
        String[] values = StringUtils.splitByWholeSeparator((String)arrayString, (String)delimiter);
        int arrayLength = values != null ? values.length : 0;
        Object o = Array.newInstance(targetType, arrayLength);
        if (arrayLength == 0) {
            return o;
        }
        ArraySetter setter = parser == null ? AConfig.getArraySetter(targetType) : AConfig.getArraySetter(parser);
        for (int i = 0; i < arrayLength; ++i) {
            String valueStr = values[i];
            try {
                if (valueStr == null) {
                    Array.set(o, i, null);
                    continue;
                }
                setter.set(o, i, valueStr);
                continue;
            }
            catch (RuntimeException e) {
                throw new SettingsException("Can't parse value " + valueStr + " to type " + targetType.getName(), e);
            }
        }
        return o;
    }

    private Object getCollectionFieldValue(IValueGetter properties, String prefixName, Method method, String delimiter, IParser<?> parser) throws SettingsException {
        AbstractCollection collection;
        boolean isSet;
        boolean isList;
        Class<?> proposalReturnClass;
        Class returnRawType;
        String arrayString = this.getStringValue(properties, prefixName, method);
        if (arrayString == null) {
            return null;
        }
        if (method.getGenericReturnType() instanceof ParameterizedType) {
            ParameterizedType returnType = (ParameterizedType)method.getGenericReturnType();
            if (!(returnType.getRawType() instanceof Class)) {
                throw new SettingsException("Raw type is not a class " + returnType + " in method " + method.toString());
            }
            returnRawType = (Class)returnType.getRawType();
            proposalReturnClass = BuilderUtils.detectTypeArgClass((Type)returnType);
        } else {
            returnRawType = (Class)method.getGenericReturnType();
            proposalReturnClass = null;
        }
        CollectionOf collectionOf = method.getAnnotation(CollectionOf.class);
        Class<?> targetType = collectionOf != null ? collectionOf.value() : proposalReturnClass;
        if (proposalReturnClass != null && !targetType.isAssignableFrom(proposalReturnClass)) {
            throw new SettingsException("Specified return object " + targetType.getName() + " cannot be casted to " + proposalReturnClass.getName());
        }
        if (targetType == null) {
            throw new SettingsException("Cannot detect component type of list. Please, use @CollectionOf annotation for method " + method.toString());
        }
        if (parser != null && !targetType.isAssignableFrom(parser.getReturnType())) {
            throw new SettingsException("Converter return type " + parser.getReturnType().getName() + " can't be assigned to array component type" + targetType.getName() + " for method " + method.getName());
        }
        String[] values = StringUtils.splitByWholeSeparator((String)arrayString, (String)delimiter);
        if (returnRawType.equals(Set.class)) {
            if (values == null || values.length == 0) {
                return Collections.emptySet();
            }
            isList = false;
            isSet = true;
            collection = Enum.class.isAssignableFrom(targetType) ? EnumSet.noneOf(targetType) : new LinkedHashSet(values.length);
        } else if (returnRawType.equals(List.class) || returnRawType.equals(Collection.class)) {
            if (values == null || values.length == 0) {
                return Collections.emptyList();
            }
            isList = returnRawType.equals(List.class);
            isSet = false;
            collection = new ArrayList(values.length);
        } else {
            throw new SettingsException("Please, specify container by interface " + Collection.class.getName() + ", " + List.class.getName() + " or " + Set.class.getName() + " as return type for collections.");
        }
        if (targetType.isInterface() || Modifier.isAbstract(targetType.getModifiers())) {
            throw new SettingsException("Only non-abstract classes could be specified as collection elements");
        }
        Function<String, Object> converter = parser == null ? AConfig.getToObjectConverter(targetType) : parser;
        for (String valueStr : values) {
            try {
                if (valueStr == null) {
                    collection.add(null);
                    continue;
                }
                collection.add(converter.apply(valueStr));
            }
            catch (RuntimeException e) {
                throw new SettingsException("Can't parse value " + valueStr + " to type " + targetType.getName(), e);
            }
        }
        if (isList) {
            return Collections.unmodifiableList((List)((Object)collection));
        }
        if (isSet) {
            return Collections.unmodifiableSet((Set)((Object)collection));
        }
        return Collections.unmodifiableCollection(collection);
    }

    private Map getMapFieldValue(IValueGetter properties, String prefixName, Method method, String delimiter) throws SettingsException {
        Class<?> proposalValueClass;
        Class<?> proposalKeyClass;
        Class returnRawType;
        String arrayString = this.getStringValue(properties, prefixName, method);
        if (arrayString == null) {
            return null;
        }
        if (method.getGenericReturnType() instanceof ParameterizedType) {
            ParameterizedType returnType = (ParameterizedType)method.getGenericReturnType();
            if (!(returnType.getRawType() instanceof Class)) {
                throw new SettingsException("Raw type is not a class " + returnType + " in method " + method.toString());
            }
            returnRawType = (Class)returnType.getRawType();
            Class[] detectTypeArgsClass = BuilderUtils.detectTypeArgsClass((Type)returnType, (int)2);
            proposalKeyClass = detectTypeArgsClass[0];
            proposalValueClass = detectTypeArgsClass[1];
        } else {
            returnRawType = (Class)method.getGenericReturnType();
            proposalKeyClass = null;
            proposalValueClass = null;
        }
        if (!Map.class.equals((Object)returnRawType)) {
            throw new SettingsException("Please, specify general interface for maps as return type for method " + method.toString());
        }
        MapKey mapKey = method.getAnnotation(MapKey.class);
        Class<?> targetKeyType = mapKey != null ? mapKey.value() : proposalKeyClass;
        if (proposalKeyClass != null && !targetKeyType.isAssignableFrom(proposalKeyClass)) {
            throw new SettingsException("Specified return object " + targetKeyType.getName() + " cannot be casted to " + proposalKeyClass.getName());
        }
        if (targetKeyType == null) {
            throw new SettingsException("Cannot detect key component type of map. Please, use @MapKey annotation for method " + method.toString());
        }
        MapValue collectionOf = method.getAnnotation(MapValue.class);
        Class<?> targetValueType = collectionOf != null ? collectionOf.value() : proposalValueClass;
        if (proposalValueClass != null && !targetValueType.isAssignableFrom(proposalValueClass)) {
            throw new SettingsException("Specified return object " + targetValueType.getName() + " cannot be casted to " + proposalValueClass.getName());
        }
        if (targetValueType == null) {
            throw new SettingsException("Cannot detect value component type of map. Please, use @MapValue annotation for method " + method.toString());
        }
        String[] values = StringUtils.splitByWholeSeparator((String)arrayString, (String)delimiter);
        if (values == null || values.length == 0) {
            return Collections.emptyMap();
        }
        AbstractMap map = Enum.class.isAssignableFrom(targetKeyType) ? new EnumMap(targetKeyType) : new LinkedHashMap(values.length);
        Function<String, ?> keyParser = AConfig.getToObjectConverter(targetKeyType);
        Function<String, ?> valueParser = AConfig.getToObjectConverter(targetValueType);
        String splitter = ClassUtils.getSplitter(method);
        for (String part : values) {
            String valueString;
            String keyString;
            String[] parts = StringUtils.splitByWholeSeparator((String)part, (String)splitter, (int)2);
            if (parts.length < 2) {
                keyString = parts[0];
                valueString = null;
            } else {
                keyString = parts[0];
                valueString = parts[1];
            }
            try {
                Object key = keyParser.apply(keyString);
                if (valueString == null) {
                    map.put(key, null);
                    continue;
                }
                map.put(key, valueParser.apply(valueString));
            }
            catch (RuntimeException e) {
                throw new SettingsException("Can't parse value " + valueString + " to type " + targetKeyType.getName(), e);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    private <T> Map<String, T> getGroupFieldValue(ClassPool pool, Class<T> clazz, IValueGetter properties, String prefixName, Method method) throws SettingsException {
        boolean required;
        Class<?> returnType = method.getReturnType();
        if (!Map.class.equals(returnType)) {
            throw new SettingsException("Group field should have java.util.Map return type only");
        }
        Constructor<T> c = ClassUtils.getSettingsConstructor(clazz, pool);
        String propertyName = ClassUtils.buildPropertyName(prefixName, method);
        String propertyNameDot = propertyName + ".";
        Set propertyNames = properties.keySet().stream().filter(name -> name.startsWith(propertyNameDot)).collect(Collectors.toSet());
        HashSet<String> prefixes = new HashSet<String>();
        for (Method mm : clazz.getMethods()) {
            if (ClassUtils.ignoreMethod(mm)) continue;
            String suffix = "." + ClassUtils.buildPropertyName(null, mm);
            for (String name2 : propertyNames) {
                int cutLen;
                if (!name2.endsWith(suffix)) continue;
                int prefixLen = propertyNameDot.length();
                String prefix = prefixLen >= (cutLen = name2.length() - suffix.length()) ? "" : name2.substring(prefixLen, cutLen);
                prefixes.add(prefix);
            }
        }
        boolean bl = required = method.getAnnotation(Optional.class) == null;
        if (required && !prefixes.contains("")) {
            throw new SettingsException("A default group set is required for method " + method.getName());
        }
        HashMap<String, T> result = new HashMap<String, T>();
        for (String p : prefixes) {
            String realPrefix = StringUtils.isNotBlank((CharSequence)p) ? propertyNameDot + p : propertyName;
            result.put(p, ClassUtils.initialize(c, this.buildConstructorParameters(pool, clazz, realPrefix, properties)));
        }
        return Collections.unmodifiableMap(result);
    }
}

