/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.settings.config;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javassist.ClassPool;
import org.xblackcat.sjpu.builder.BuilderUtils;
import org.xblackcat.sjpu.settings.SettingsException;
import org.xblackcat.sjpu.settings.config.AConfig;
import org.xblackcat.sjpu.settings.config.IConfig;
import org.xblackcat.sjpu.settings.util.ClassUtils;
import org.xblackcat.sjpu.settings.util.IValueGetter;
import org.xblackcat.sjpu.util.function.SupplierEx;

public abstract class APermanentConfig
extends AConfig
implements IConfig {
    private IValueGetter loadedProperties;

    public APermanentConfig(ClassPool pool, Map<String, UnaryOperator<String>> prefixHandlers, List<SupplierEx<IValueGetter, SettingsException>> substitutions) {
        super(pool, prefixHandlers, substitutions);
    }

    @Override
    public <T> T get(Class<T> clazz, String prefixName, boolean optional) throws SettingsException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Load defaults for class " + clazz.getName() + " [prefix: " + prefixName + "]"));
        }
        ClassPool pool = BuilderUtils.getClassPool((ClassPool)this.pool, clazz, (Class[])new Class[0]);
        Constructor<T> c = ClassUtils.getSettingsConstructor(clazz, pool);
        IValueGetter loadedProperties = this.getValueGetter();
        if (loadedProperties == null) {
            if (ClassUtils.allMethodsHaveDefaults(clazz)) {
                loadedProperties = IValueGetter.EMPTY;
            } else {
                if (optional) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)(clazz.getName() + " marked as optional"));
                    }
                    return null;
                }
                throw new SettingsException(clazz.getName() + " has mandatory properties without default values");
            }
        }
        List<Object> values = this.buildConstructorParameters(pool, clazz, prefixName, loadedProperties);
        return ClassUtils.initialize(c, values);
    }

    @Override
    public IValueGetter getValueGetter() throws SettingsException {
        if (this.loadedProperties == null) {
            try {
                this.loadedProperties = this.loadProperties();
            }
            catch (IOException e) {
                throw new SettingsException("Can't obtain list of values ", e);
            }
        }
        return this.loadedProperties;
    }

    protected abstract IValueGetter loadProperties() throws IOException;
}

