/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.settings.config;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javassist.ClassPool;
import org.xblackcat.sjpu.builder.BuilderUtils;
import org.xblackcat.sjpu.settings.SettingsException;
import org.xblackcat.sjpu.settings.config.AConfig;
import org.xblackcat.sjpu.settings.config.APermanentConfig;
import org.xblackcat.sjpu.settings.config.ConfigInfo;
import org.xblackcat.sjpu.settings.config.IConfig;
import org.xblackcat.sjpu.settings.config.IConfigListener;
import org.xblackcat.sjpu.settings.config.IMutableConfig;
import org.xblackcat.sjpu.settings.config.ISettingsWrapper;
import org.xblackcat.sjpu.settings.config.InputStreamConfig;
import org.xblackcat.sjpu.settings.util.ClassUtils;
import org.xblackcat.sjpu.settings.util.IValueGetter;
import org.xblackcat.sjpu.settings.util.LoadUtils;
import org.xblackcat.sjpu.util.function.SupplierEx;

public class MutableConfig
extends AConfig
implements IMutableConfig,
IConfig {
    private final Lock lock = new ReentrantLock();
    private final List<IConfigListener> listenerList = new ArrayList<IConfigListener>();
    private final Map<ConfigInfo<?>, ISettingsWrapper<?>> loadedObjects = new HashMap();
    private final Path file;
    private final Path parent;
    private final APermanentConfig wrappedConfig;
    private final Consumer<Runnable> notifyConsumer;
    private volatile IValueGetter loadedProperties;

    public MutableConfig(ClassPool pool, Map<String, UnaryOperator<String>> prefixHandlers, List<SupplierEx<IValueGetter, SettingsException>> substitutions, Path file, Consumer<Runnable> notifyConsumer) {
        super(pool, prefixHandlers, substitutions);
        this.file = file;
        this.parent = file.getParent();
        this.notifyConsumer = notifyConsumer;
        this.wrappedConfig = new InputStreamConfig(pool, prefixHandlers, substitutions, (SupplierEx<InputStream, IOException>)((SupplierEx)() -> LoadUtils.getInputStream(file)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(Class<T> clazz, String prefixName, boolean optional) throws SettingsException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initialize mutable config for class " + clazz.getName() + " [prefix: " + prefixName + "]"));
        }
        ClassPool pool = BuilderUtils.getClassPool((ClassPool)this.pool, clazz, (Class[])new Class[0]);
        ConfigInfo<T> configInfo = new ConfigInfo<T>(clazz, prefixName, optional);
        this.lock.lock();
        try {
            ISettingsWrapper<T> wrappedData;
            IValueGetter properties;
            ISettingsWrapper<?> wrapper = this.loadedObjects.get(configInfo);
            if (wrapper != null) {
                ISettingsWrapper<?> iSettingsWrapper = wrapper;
                return (T)iSettingsWrapper;
            }
            if (this.loadedProperties == null) {
                this.loadedProperties = properties = this.reloadFile();
            } else {
                properties = this.loadedProperties;
            }
            T object = this.initObject(pool, configInfo, properties);
            Constructor<ISettingsWrapper<T>> dataWrapper = ClassUtils.getSettingsWrapperConstructor(clazz, pool);
            ISettingsWrapper<T> dw = ClassUtils.initialize(dataWrapper, object);
            this.loadedObjects.put(configInfo, dw);
            ISettingsWrapper<T> iSettingsWrapper = wrappedData = dw;
            return (T)iSettingsWrapper;
        }
        finally {
            this.lock.unlock();
        }
    }

    private <T> T initObject(ClassPool pool, ConfigInfo<T> configInfo, IValueGetter loadedProperties) throws SettingsException {
        Class<T> clazz = configInfo.getClazz();
        String prefixName = configInfo.getPrefix();
        boolean optional = configInfo.isOptional();
        try {
            Constructor<T> c = ClassUtils.getSettingsConstructor(clazz, pool);
            List<Object> values = this.buildConstructorParameters(pool, clazz, prefixName, loadedProperties);
            return ClassUtils.initialize(c, values);
        }
        catch (SettingsException e) {
            if (optional) {
                return null;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadConfigs() {
        IValueGetter properties = this.reloadFile();
        this.lock.lock();
        try {
            this.loadedProperties = properties;
            for (Map.Entry<ConfigInfo<?>, ISettingsWrapper<?>> e : this.loadedObjects.entrySet()) {
                try {
                    ConfigInfo<?> configInfo = e.getKey();
                    ISettingsWrapper<?> wrapper = e.getValue();
                    Class<?> clazz = configInfo.getClazz();
                    Object data = this.initObject(this.pool, configInfo, properties);
                    Object oldData = wrapper.getConfig();
                    if (Objects.equals(data, oldData)) {
                        if (!this.log.isTraceEnabled()) continue;
                        this.log.trace((Object)("Configuration is not changed for " + configInfo));
                        continue;
                    }
                    this.updateObject(wrapper, data);
                    for (IConfigListener l : this.listenerList) {
                        this.notifyConsumer.accept(() -> l.onConfigChanged(clazz, configInfo.getPrefix(), data));
                    }
                }
                catch (Throwable ex) {
                    this.log.debug((Object)"Failed to parse properties - ignore request", ex);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private IValueGetter reloadFile() {
        IValueGetter properties;
        block4: {
            properties = null;
            try {
                properties = this.wrappedConfig.loadProperties();
            }
            catch (IOException e) {
                if (!this.log.isDebugEnabled()) break block4;
                this.log.debug((Object)"Failed to load properties - try to use defaults", (Throwable)e);
            }
        }
        if (properties == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"No data is loaded - try to use defaults");
            }
            properties = IValueGetter.EMPTY;
        }
        return properties;
    }

    private void updateObject(ISettingsWrapper wrapper, Object data) {
        wrapper.setConfig(data);
    }

    @Override
    public void addListener(IConfigListener listener) {
        this.lock.lock();
        try {
            this.listenerList.add(listener);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void removeListener(IConfigListener listener) {
        this.lock.lock();
        try {
            this.listenerList.remove(listener);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void checkPaths(Set<Path> paths) {
        for (Path p : paths) {
            if (!this.parent.resolve(p).equals(this.file)) continue;
            this.reloadConfigs();
            return;
        }
    }

    @Override
    public IValueGetter getValueGetter() {
        return this.reloadFile();
    }
}

