/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.settings.converter;

import java.time.Duration;
import java.time.format.DateTimeParseException;
import org.xblackcat.sjpu.settings.converter.IParser;

public class DurationParser
implements IParser<Duration> {
    @Override
    public Class<Duration> getReturnType() {
        return Duration.class;
    }

    @Override
    public Duration apply(String s) {
        try {
            return Duration.parse(s);
        }
        catch (DateTimeParseException e) {
            DateTimeParseException cachedException = e;
            try {
                return Duration.parse("P" + s);
            }
            catch (DateTimeParseException dateTimeParseException) {
                try {
                    return Duration.parse("PT" + s);
                }
                catch (DateTimeParseException dateTimeParseException2) {
                    try {
                        return Duration.parse("PT" + s + "S");
                    }
                    catch (DateTimeParseException dateTimeParseException3) {
                        throw cachedException;
                    }
                }
            }
        }
    }

    @Override
    public String formatDescription() {
        return "The formats accepted are based on the ISO-8601 duration format PnDTnHnMn.nS. Possible to specify the string without 'P' prefix or as number. In the last case the number will be treated as seconds amount";
    }
}

