/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.settings.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xblackcat.sjpu.builder.BuilderUtils;
import org.xblackcat.sjpu.settings.NotImplementedException;
import org.xblackcat.sjpu.settings.NotLoadedException;
import org.xblackcat.sjpu.settings.SettingsException;
import org.xblackcat.sjpu.settings.ann.DefaultValue;
import org.xblackcat.sjpu.settings.ann.Delimiter;
import org.xblackcat.sjpu.settings.ann.Ignore;
import org.xblackcat.sjpu.settings.ann.Optional;
import org.xblackcat.sjpu.settings.ann.ParseWith;
import org.xblackcat.sjpu.settings.ann.PropertyName;
import org.xblackcat.sjpu.settings.ann.Splitter;
import org.xblackcat.sjpu.settings.config.ISettingsWrapper;
import org.xblackcat.sjpu.settings.converter.IParser;

public class ClassUtils {
    private static final Log log = LogFactory.getLog(ClassUtils.class);
    private static final String DEFAULT_DELIMITER = ",";
    private static final String DEFAULT_SPLITTER = ":";
    private static final String NOT_LOADED_EXCEPTION_CLASS = BuilderUtils.getName(NotLoadedException.class);

    public static String buildPropertyName(Method m) {
        return ClassUtils.buildPropertyName(null, m);
    }

    public static String buildPropertyName(String prefixName, Method m) {
        PropertyName field;
        StringBuilder propertyNameBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)prefixName)) {
            propertyNameBuilder.append(prefixName);
            propertyNameBuilder.append('.');
        }
        if ((field = m.getAnnotation(PropertyName.class)) != null && StringUtils.isNotBlank((CharSequence)field.value())) {
            propertyNameBuilder.append(field.value());
        } else {
            String fieldName = BuilderUtils.makeFieldName((String)m.getName());
            boolean onHump = true;
            for (char c : fieldName.toCharArray()) {
                if (Character.isUpperCase(c)) {
                    if (!onHump) {
                        propertyNameBuilder.append('.');
                        onHump = true;
                    }
                } else {
                    onHump = false;
                }
                propertyNameBuilder.append(Character.toLowerCase(c));
            }
        }
        return propertyNameBuilder.toString();
    }

    public static IParser<?> getCustomConverter(Method method) throws SettingsException {
        IParser<?> parser;
        ParseWith parseWith = method.getAnnotation(ParseWith.class);
        if (parseWith == null) {
            return null;
        }
        Class<IParser<?>> aClass = parseWith.value();
        try {
            aClass.getConstructor(new Class[0]);
            parser = aClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new SettingsException("Failed to instantiate converter class " + aClass, e);
        }
        catch (IllegalAccessException e) {
            throw new SettingsException("Failed to initialize converter class " + aClass, e);
        }
        catch (NoSuchMethodException e) {
            throw new SettingsException("Converter class " + aClass + " should have default public constructor", e);
        }
        return parser;
    }

    public static String getDelimiter(Method method) {
        Delimiter delimiterAnn = method.getAnnotation(Delimiter.class);
        if (delimiterAnn == null) {
            return DEFAULT_DELIMITER;
        }
        return delimiterAnn.value();
    }

    public static String getSplitter(Method method) {
        Splitter splitterAnn = method.getAnnotation(Splitter.class);
        if (splitterAnn == null) {
            return DEFAULT_SPLITTER;
        }
        return splitterAnn.value();
    }

    public static synchronized <T> Constructor<T> getSettingsConstructor(Class<T> clazz, ClassPool pool) throws SettingsException {
        Class aClass;
        String implName = clazz.getName() + "$Impl";
        try {
            aClass = Class.forName(implName, true, pool.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                CtClass settingsClass = ClassUtils.buildSettingsClass(clazz, pool);
                aClass = settingsClass.toClass();
                settingsClass.detach();
            }
            catch (CannotCompileException ee) {
                throw new SettingsException("Can't initialize a constructor for generated class " + clazz.getName(), ee);
            }
        }
        Constructor<?> constructor = aClass.getConstructors()[0];
        return constructor;
    }

    public static synchronized <T> Constructor<ISettingsWrapper<T>> getSettingsWrapperConstructor(Class<T> clazz, ClassPool pool) throws SettingsException {
        Class aClass;
        String implName = clazz.getName() + "$Wrapper";
        try {
            aClass = Class.forName(implName, true, pool.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                CtClass settingsClass = ClassUtils.buildSettingsWrapperClass(clazz, pool);
                aClass = settingsClass.toClass();
                settingsClass.detach();
            }
            catch (CannotCompileException ee) {
                throw new SettingsException("Can't initialize a constructor for generated class " + clazz.getName(), ee);
            }
        }
        Constructor<ISettingsWrapper<T>> constructor = aClass.getConstructors()[0];
        return constructor;
    }

    private static <T> CtClass buildSettingsClass(Class<T> clazz, ClassPool pool) throws SettingsException {
        CtClass settingsClass;
        if (!clazz.isInterface()) {
            throw new SettingsException("Only annotated interfaces are supported. " + clazz.getName() + " is a class.");
        }
        try {
            CtClass settingsInterface = pool.get(clazz.getName());
            settingsClass = settingsInterface.makeNestedClass("Impl", true);
            settingsClass.addInterface(settingsInterface);
        }
        catch (NotFoundException e) {
            throw new SettingsException("Can't generate class for settings", e);
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        StringBuilder toStringBody = new StringBuilder();
        StringBuilder equalsBody = new StringBuilder();
        StringBuilder constructorBody = new StringBuilder();
        ArrayList<CtClass> constructorParameters = new ArrayList<CtClass>();
        constructorBody.append("{\n");
        toStringBody.append("{\nreturn \"");
        toStringBody.append(clazz.getSimpleName());
        toStringBody.append(" [\"");
        String className = settingsClass.getName();
        equalsBody.append("{\nif (this == $1) return true;\nif ($1 == null || getClass() != $1.getClass()) return false;\nfinal ");
        equalsBody.append(className);
        equalsBody.append(" that = (");
        equalsBody.append(className);
        equalsBody.append(") $1;\n return true");
        int idx = 1;
        for (Method m : clazz.getMethods()) {
            CtClass retType;
            String mName = m.getName();
            Class<?> returnType = m.getReturnType();
            if (m.isDefault()) {
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Ignore default method " + m + " in interface " + clazz.getName()));
                continue;
            }
            if (m.isAnnotationPresent(Ignore.class)) {
                ClassUtils.addIgnoredImplementation(pool, settingsClass, m, mName, returnType);
                continue;
            }
            if (m.getParameterTypes().length > 0) {
                throw new SettingsException("Method " + m.toString() + " has parameters - can't be processed as getter");
            }
            String fieldName = BuilderUtils.makeFieldName((String)mName);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Generate a property " + fieldName + " for class " + clazz.getName() + " of type " + returnType.getName()));
            }
            try {
                retType = pool.get(returnType.getName());
            }
            catch (NotFoundException e) {
                throw new SettingsException("Somehow a class " + returnType.getName() + " can't be found", e);
            }
            boolean returnTypeArray = returnType.isArray();
            try {
                CtField f = new CtField(retType, "__" + fieldName, settingsClass);
                f.setModifiers(18);
                settingsClass.addField(f);
                String body = returnTypeArray ? "{ return ($r) this.__" + fieldName + ".clone(); }" : "{ return this.__" + fieldName + "; }";
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Implement method " + clazz.getName() + "#" + mName + "() " + body));
                }
                CtMethod getter = CtNewMethod.make((int)17, (CtClass)retType, (String)mName, (CtClass[])BuilderUtils.EMPTY_LIST, (CtClass[])BuilderUtils.EMPTY_LIST, (String)body, (CtClass)settingsClass);
                settingsClass.addMethod(getter);
            }
            catch (CannotCompileException e) {
                throw new SettingsException("Can't add a field __" + fieldName + " to generated class", e);
            }
            if (returnTypeArray) {
                constructorBody.append("if ($");
                constructorBody.append(idx);
                constructorBody.append(" != null) {\n");
                constructorBody.append("this.__");
                constructorBody.append(fieldName);
                constructorBody.append(" = (");
                constructorBody.append(BuilderUtils.getName(returnType));
                constructorBody.append(")$");
                constructorBody.append(idx);
                constructorBody.append(".clone();\n");
                constructorBody.append("} else {\n");
                constructorBody.append("this.__");
                constructorBody.append(fieldName);
                constructorBody.append(" = null;\n}\n");
            } else {
                constructorBody.append("this.__");
                constructorBody.append(fieldName);
                constructorBody.append(" = $");
                constructorBody.append(idx);
                constructorBody.append(";\n");
            }
            equalsBody.append(" &&\n");
            if (returnTypeArray) {
                equalsBody.append("java.util.Arrays.equals(__");
                equalsBody.append(fieldName);
                equalsBody.append(", that.__");
                equalsBody.append(fieldName);
                equalsBody.append(")");
            } else if (returnType.isPrimitive() || returnType.isEnum()) {
                equalsBody.append("__");
                equalsBody.append(fieldName);
                equalsBody.append(" == that.__");
                equalsBody.append(fieldName);
                equalsBody.append("");
            } else {
                equalsBody.append("java.util.Objects.equals(__");
                equalsBody.append(fieldName);
                equalsBody.append(", that.__");
                equalsBody.append(fieldName);
                equalsBody.append(")");
            }
            fieldNames.add("($w) __" + fieldName);
            toStringBody.append(" + \"");
            toStringBody.append(fieldName);
            toStringBody.append(" (");
            toStringBody.append(ClassUtils.buildPropertyName(null, m));
            toStringBody.append(") = \\\"\" + java.lang.String.valueOf(this.__");
            toStringBody.append(fieldName);
            toStringBody.append(") + \"\\\"; \"");
            constructorParameters.add(retType);
            ++idx;
        }
        if (idx == 1) {
            throw new SettingsException("Can't load settings to a class without properties. Class " + className);
        }
        constructorBody.append("}");
        toStringBody.setLength(toStringBody.length() - 3);
        toStringBody.append("]\";\n}");
        equalsBody.append(";\n}");
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Generated method " + clazz.getName() + "#equals() " + equalsBody.toString()));
            }
            CtMethod equals = CtNewMethod.make((int)17, (CtClass)pool.get(Boolean.TYPE.getName()), (String)"equals", (CtClass[])pool.get(new String[]{"java.lang.Object"}), (CtClass[])BuilderUtils.EMPTY_LIST, (String)equalsBody.toString(), (CtClass)settingsClass);
            settingsClass.addMethod(equals);
            String hashCodeBody = "{\nreturn java.util.Objects.hash(new java.lang.Object[]{\n" + String.join((CharSequence)",\n", fieldNames) + "\n});\n}";
            if (log.isTraceEnabled()) {
                log.trace((Object)("Generated method " + clazz.getName() + "#hashCode() " + hashCodeBody));
            }
            CtMethod hashCode = CtNewMethod.make((int)17, (CtClass)pool.get(Integer.TYPE.getName()), (String)"hashCode", (CtClass[])BuilderUtils.EMPTY_LIST, (CtClass[])BuilderUtils.EMPTY_LIST, (String)hashCodeBody, (CtClass)settingsClass);
            settingsClass.addMethod(hashCode);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Generated method " + clazz.getName() + "#toString() " + toStringBody.toString()));
            }
            CtMethod toString = CtNewMethod.make((int)17, (CtClass)pool.get(String.class.getName()), (String)"toString", (CtClass[])BuilderUtils.EMPTY_LIST, (CtClass[])BuilderUtils.EMPTY_LIST, (String)toStringBody.toString(), (CtClass)settingsClass);
            settingsClass.addMethod(toString);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Generated constructor " + clazz.getName() + "() " + constructorBody.toString()));
            }
            CtConstructor constructor = CtNewConstructor.make((CtClass[])constructorParameters.toArray(new CtClass[constructorParameters.size()]), (CtClass[])BuilderUtils.EMPTY_LIST, (String)constructorBody.toString(), (CtClass)settingsClass);
            settingsClass.addConstructor(constructor);
            return settingsClass;
        }
        catch (CannotCompileException e) {
            throw new SettingsException("Can't generate a constructor for generated class " + clazz.getName(), e);
        }
        catch (NotFoundException e) {
            throw new SettingsException("Can't generate toString() method for generated class " + clazz.getName(), e);
        }
    }

    private static <T> CtClass buildSettingsWrapperClass(Class<T> clazz, ClassPool pool) throws SettingsException {
        CtClass settingsClass;
        CtClass settingsInterface;
        if (!clazz.isInterface()) {
            throw new SettingsException("Only annotated interfaces are supported. " + clazz.getName() + " is a class.");
        }
        try {
            settingsInterface = pool.get(clazz.getName());
            settingsClass = settingsInterface.makeNestedClass("Wrapper", true);
            settingsClass.addInterface(settingsInterface);
            settingsClass.addInterface(BuilderUtils.toCtClass((ClassPool)pool, ISettingsWrapper.class));
        }
        catch (NotFoundException e) {
            throw new SettingsException("Can't generate class for settings", e);
        }
        try {
            CtField f = new CtField(pool.get(ReadWriteLock.class.getName()), "__lock", settingsClass);
            f.setModifiers(18);
            settingsClass.addField(f);
            f = new CtField(settingsInterface, "__config", settingsClass);
            f.setModifiers(66);
            settingsClass.addField(f);
        }
        catch (CannotCompileException | NotFoundException e) {
            throw new SettingsException("Can't initialize fields in class for settings", e);
        }
        for (Method m : clazz.getMethods()) {
            CtClass retType;
            String mName = m.getName();
            Class<?> returnType = m.getReturnType();
            if (m.isDefault()) {
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Ignore default method " + m + " in interface " + clazz.getName()));
                continue;
            }
            if (m.isAnnotationPresent(Ignore.class)) {
                ClassUtils.addIgnoredImplementation(pool, settingsClass, m, mName, returnType);
                continue;
            }
            if (m.getParameterTypes().length > 0) {
                throw new SettingsException("Method " + m.toString() + " has parameters - can't be processed as getter");
            }
            try {
                retType = pool.get(returnType.getName());
            }
            catch (NotFoundException e) {
                throw new SettingsException("Somehow a class " + returnType.getName() + " can't be found", e);
            }
            try {
                String body = "{\nthis.__lock.readLock().lock();\ntry {\nif (this.__config == null) {\nthrow new " + NOT_LOADED_EXCEPTION_CLASS + "(\"Optional config " + clazz.getName() + " is not loaded\");\n}\nreturn ($r) this.__config." + mName + "();\n} finally {\nthis.__lock.readLock().unlock();\n}\n}";
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Implement method " + clazz.getName() + "#" + mName + "() " + body));
                }
                CtMethod proxy = CtNewMethod.make((int)17, (CtClass)retType, (String)mName, (CtClass[])BuilderUtils.EMPTY_LIST, (CtClass[])BuilderUtils.EMPTY_LIST, (String)body, (CtClass)settingsClass);
                settingsClass.addMethod(proxy);
            }
            catch (CannotCompileException e) {
                throw new SettingsException("Can't add a proxy method " + mName + " to generated class", e);
            }
        }
        String toStringBody = "{\nthis.__lock.readLock().lock();\ntry {\nreturn \"" + clazz.getSimpleName() + " wrapper of \" + String.valueOf(this.__config);\n} finally {\nthis.__lock.readLock().unlock();\n}\n}";
        String constructorBody = "{\nthis.__config = $1;\nthis.__lock = new " + BuilderUtils.getName(ReentrantReadWriteLock.class) + "();\n}";
        String getterBody = "{\nthis.__lock.readLock().lock();\ntry {\nreturn ($r) this.__config;\n} finally {\nthis.__lock.readLock().unlock();\n}\n}";
        String setterBody = "{\nthis.__lock.writeLock().lock();\ntry {\nthis.__config = $1;\n} finally {\nthis.__lock.writeLock().unlock();\n}\n}";
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Generated setter " + clazz.getName() + "#setConfig() " + setterBody));
            }
            CtMethod setter = CtNewMethod.make((int)17, (CtClass)pool.get(Void.TYPE.getName()), (String)"setConfig", (CtClass[])new CtClass[]{pool.get(Object.class.getName())}, (CtClass[])BuilderUtils.EMPTY_LIST, (String)setterBody, (CtClass)settingsClass);
            settingsClass.addMethod(setter);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Generated getter " + clazz.getName() + "#getConfig() " + getterBody));
            }
            CtMethod getter = CtNewMethod.make((int)17, (CtClass)pool.get(Object.class.getName()), (String)"getConfig", (CtClass[])BuilderUtils.EMPTY_LIST, (CtClass[])BuilderUtils.EMPTY_LIST, (String)getterBody, (CtClass)settingsClass);
            settingsClass.addMethod(getter);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Generated method " + clazz.getName() + "#toString() " + toStringBody));
            }
            CtMethod toString = CtNewMethod.make((int)17, (CtClass)pool.get(String.class.getName()), (String)"toString", (CtClass[])BuilderUtils.EMPTY_LIST, (CtClass[])BuilderUtils.EMPTY_LIST, (String)toStringBody, (CtClass)settingsClass);
            settingsClass.addMethod(toString);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Generated constructor " + clazz.getName() + "() " + constructorBody));
            }
            CtConstructor constructor = CtNewConstructor.make((CtClass[])new CtClass[]{settingsInterface}, (CtClass[])BuilderUtils.EMPTY_LIST, (String)constructorBody, (CtClass)settingsClass);
            settingsClass.addConstructor(constructor);
            return settingsClass;
        }
        catch (CannotCompileException e) {
            throw new SettingsException("Can't generate a constructor for generated class " + clazz.getName(), e);
        }
        catch (NotFoundException e) {
            throw new SettingsException("Can't generate toString() method for generated class " + clazz.getName(), e);
        }
    }

    private static void addIgnoredImplementation(ClassPool pool, CtClass settingsClass, Method m, String mName, Class<?> returnType) throws SettingsException {
        CtClass retType;
        try {
            retType = pool.get(returnType.getName());
        }
        catch (NotFoundException e) {
            throw new SettingsException("Somehow a class " + returnType.getName() + " can't be found", e);
        }
        try {
            CtMethod dumbMethod = CtNewMethod.make((int)17, (CtClass)retType, (String)mName, (CtClass[])BuilderUtils.toCtClasses((ClassPool)pool, (Class[])m.getParameterTypes()), (CtClass[])BuilderUtils.toCtClasses((ClassPool)pool, (Class[])m.getExceptionTypes()), (String)("{ throw new " + NotImplementedException.class.getName() + "(\"Method " + mName + " is excluded from generation\"); }"), (CtClass)settingsClass);
            settingsClass.addMethod(dumbMethod);
        }
        catch (CannotCompileException | NotFoundException e) {
            throw new SettingsException("Can't add a dumb method " + mName + " to generated class", e);
        }
    }

    public static <T> T initialize(Constructor<T> c, List<Object> values) throws SettingsException {
        Object[] array = values.toArray();
        return ClassUtils.initialize(c, array);
    }

    public static <T> T initialize(Constructor<T> c, Object ... values) throws SettingsException {
        try {
            return c.newInstance(values);
        }
        catch (InstantiationException e) {
            throw new SettingsException("Can't make a new instance of my own class :(", e);
        }
        catch (IllegalAccessException e) {
            throw new SettingsException("Can't get access to my own class :(", e);
        }
        catch (InvocationTargetException e) {
            throw new SettingsException("My class produces an exception :(", e);
        }
    }

    public static <T> boolean allMethodsHaveDefaults(Class<T> clazz) {
        for (Method m : clazz.getDeclaredMethods()) {
            if (ClassUtils.ignoreMethod(m) || m.isAnnotationPresent(DefaultValue.class) || m.isAnnotationPresent(Optional.class)) continue;
            return false;
        }
        return true;
    }

    public static boolean ignoreMethod(Method method) {
        return method.isDefault() || method.isAnnotationPresent(Ignore.class);
    }
}

