/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.settings.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.xblackcat.sjpu.settings.config.InputStreamConfig;
import org.xblackcat.sjpu.settings.util.IValueGetter;
import org.xblackcat.sjpu.settings.util.MapWrapper;
import org.xblackcat.sjpu.util.function.SupplierEx;

public class LoadUtils {
    public static IValueGetter loadProperties(SupplierEx<InputStream, IOException> inputStreamProvider) throws IOException {
        if (inputStreamProvider == null) {
            return null;
        }
        final LinkedHashMap<String, String> shadow = new LinkedHashMap<String, String>();
        Properties properties = new Properties(){

            @Override
            public synchronized Object put(Object key, Object value) {
                return shadow.put(Objects.toString(key, null), Objects.toString(value, null));
            }
        };
        try (InputStream in = (InputStream)inputStreamProvider.get();){
            if (in == null) {
                IValueGetter iValueGetter = null;
                return iValueGetter;
            }
            properties.load(new InputStreamReader((InputStream)new BufferedInputStream(in), StandardCharsets.UTF_8));
        }
        return LoadUtils.wrap(shadow);
    }

    public static MapWrapper wrap(Map<String, String> shadow) {
        return new MapWrapper(shadow);
    }

    public static InputStream getInputStream(Path file) throws IOException {
        if (!Files.isReadable(file)) {
            throw new IOException("Read access denied for file " + file);
        }
        return Files.newInputStream(file, StandardOpenOption.READ);
    }

    public static InputStream buildInputStreamProvider(String resourceName) throws IOException {
        InputStream is;
        if (resourceName == null) {
            return null;
        }
        if (!resourceName.endsWith(".properties") && (is = LoadUtils.getInputStream(resourceName + ".properties")) != null) {
            return is;
        }
        return LoadUtils.getInputStream(resourceName);
    }

    public static InputStream getInputStream(String propertiesFile) throws IOException {
        InputStream is = InputStreamConfig.class.getResourceAsStream(propertiesFile);
        if (is == null) {
            is = InputStreamConfig.class.getClassLoader().getResourceAsStream(propertiesFile);
        }
        return is;
    }

    public static InputStream getInputStream(File file) throws IOException {
        if (file == null) {
            return null;
        }
        if (!file.canRead()) {
            throw new IOException("Read access denied for file " + file);
        }
        return new FileInputStream(file);
    }
}

