/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.util.function;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.xblackcat.sjpu.util.function.CoveringException;
import org.xblackcat.sjpu.util.function.SupplierEx;

@FunctionalInterface
public interface FunctionEx<T, R, E extends Throwable> {
    public static <T, E extends Throwable> FunctionEx<T, T, E> identity() {
        return t -> t;
    }

    public R apply(T var1) throws E;

    default public <V> FunctionEx<V, R, E> compose(FunctionEx<? super V, ? extends T, E> before) {
        Objects.requireNonNull(before);
        return v -> this.apply(before.apply((Object)v));
    }

    default public <V> FunctionEx<T, V, E> andThen(FunctionEx<? super R, ? extends V, E> after) {
        Objects.requireNonNull(after);
        return t -> after.apply((R)this.apply(t));
    }

    default public SupplierEx<R, E> fix(T t) {
        return () -> this.apply(t);
    }

    default public <C extends Throwable> FunctionEx<T, R, C> cover(String exceptionText, BiFunction<String, Throwable, C> coverage) {
        return this.cover(() -> exceptionText, coverage);
    }

    default public <C extends Throwable> FunctionEx<T, R, C> cover(BiFunction<String, Throwable, C> coverage) {
        return this.cover(Throwable::getMessage, coverage);
    }

    default public <C extends Throwable> FunctionEx<T, R, C> cover(Supplier<String> text, BiFunction<String, Throwable, C> coverage) {
        return this.cover((Throwable e) -> (String)text.get(), coverage);
    }

    default public <C extends Throwable> FunctionEx<T, R, C> cover(Function<Throwable, String> text, BiFunction<String, Throwable, C> coverage) {
        return t -> {
            try {
                return this.apply(t);
            }
            catch (Throwable e) {
                throw (Throwable)coverage.apply((String)text.apply(e), e);
            }
        };
    }

    default public Function<T, R> unchecked(String exceptionText, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked(() -> exceptionText, cover);
    }

    default public Function<T, R> unchecked() {
        return this.unchecked(CoveringException::new);
    }

    default public Function<T, R> unchecked(BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked(Throwable::getMessage, cover);
    }

    default public Function<T, R> unchecked(Supplier<String> text, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked((Throwable e) -> (String)text.get(), cover);
    }

    default public Function<T, R> unchecked(Function<Throwable, String> text, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return t -> {
            try {
                return this.apply(t);
            }
            catch (Throwable e) {
                throw (RuntimeException)cover.apply((String)text.apply(e), e);
            }
        };
    }
}

