/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.util.function;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.Supplier;
import org.xblackcat.sjpu.util.function.CoveringException;
import org.xblackcat.sjpu.util.function.IntSupplierEx;
import org.xblackcat.sjpu.util.function.IntUnaryOperatorEx;

@FunctionalInterface
public interface IntBinaryOperatorEx<E extends Throwable> {
    public int applyAsInt(int var1, int var2) throws E;

    default public IntUnaryOperatorEx<E> fixRight(int right) {
        return left -> this.applyAsInt(left, right);
    }

    default public IntUnaryOperatorEx<E> fixLeft(int left) {
        return right -> this.applyAsInt(left, right);
    }

    default public IntSupplierEx<E> fix(int left, int right) {
        return () -> this.applyAsInt(left, right);
    }

    default public <C extends Throwable> IntBinaryOperatorEx<C> cover(String exceptionText, BiFunction<String, Throwable, C> cover) {
        return this.cover(() -> exceptionText, cover);
    }

    default public <C extends Throwable> IntBinaryOperatorEx<C> cover(BiFunction<String, Throwable, C> cover) {
        return this.cover(Throwable::getMessage, cover);
    }

    default public <C extends Throwable> IntBinaryOperatorEx<C> cover(Supplier<String> text, BiFunction<String, Throwable, C> cover) {
        return this.cover((Throwable e) -> (String)text.get(), cover);
    }

    default public <C extends Throwable> IntBinaryOperatorEx<C> cover(Function<Throwable, String> text, BiFunction<String, Throwable, C> cover) {
        return (t, u) -> {
            try {
                return this.applyAsInt(t, u);
            }
            catch (Throwable e) {
                throw (Throwable)cover.apply((String)text.apply(e), e);
            }
        };
    }

    default public IntBinaryOperator unchecked(String exceptionText, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked(() -> exceptionText, cover);
    }

    default public IntBinaryOperator unchecked() {
        return this.unchecked(CoveringException::new);
    }

    default public IntBinaryOperator unchecked(BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked(Throwable::getMessage, cover);
    }

    default public IntBinaryOperator unchecked(Supplier<String> text, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked((Throwable e) -> (String)text.get(), cover);
    }

    default public IntBinaryOperator unchecked(Function<Throwable, String> text, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return (t, u) -> {
            try {
                return this.applyAsInt(t, u);
            }
            catch (Throwable e) {
                throw (RuntimeException)cover.apply((String)text.apply(e), e);
            }
        };
    }
}

