/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.util.function;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import org.xblackcat.sjpu.util.function.BooleanSupplierEx;
import org.xblackcat.sjpu.util.function.CoveringException;

@FunctionalInterface
public interface IntPredicateEx<E extends Throwable> {
    public boolean test(int var1) throws E;

    default public IntPredicateEx<E> and(IntPredicateEx<E> other) {
        Objects.requireNonNull(other);
        return value -> this.test(value) && other.test(value);
    }

    default public IntPredicateEx<E> negate() {
        return value -> !this.test(value);
    }

    default public IntPredicateEx<E> or(IntPredicateEx<E> other) {
        Objects.requireNonNull(other);
        return value -> this.test(value) || other.test(value);
    }

    default public BooleanSupplierEx<E> fix(int value) {
        return () -> this.test(value);
    }

    default public <C extends Throwable> IntPredicateEx<C> cover(String exceptionText, BiFunction<String, Throwable, C> cover) {
        return this.cover(() -> exceptionText, cover);
    }

    default public <C extends Throwable> IntPredicateEx<C> cover(BiFunction<String, Throwable, C> cover) {
        return this.cover(Throwable::getMessage, cover);
    }

    default public <C extends Throwable> IntPredicateEx<C> cover(Supplier<String> text, BiFunction<String, Throwable, C> cover) {
        return this.cover((Throwable e) -> (String)text.get(), cover);
    }

    default public <C extends Throwable> IntPredicateEx<C> cover(Function<Throwable, String> text, BiFunction<String, Throwable, C> cover) {
        return t -> {
            try {
                return this.test(t);
            }
            catch (Throwable e) {
                throw (Throwable)cover.apply((String)text.apply(e), e);
            }
        };
    }

    default public IntPredicate unchecked(String exceptionText, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked(() -> exceptionText, cover);
    }

    default public IntPredicate unchecked() {
        return this.unchecked(CoveringException::new);
    }

    default public IntPredicate unchecked(BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked(Throwable::getMessage, cover);
    }

    default public IntPredicate unchecked(Supplier<String> text, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked((Throwable e) -> (String)text.get(), cover);
    }

    default public IntPredicate unchecked(Function<Throwable, String> text, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return t -> {
            try {
                return this.test(t);
            }
            catch (Throwable e) {
                throw (RuntimeException)cover.apply((String)text.apply(e), e);
            }
        };
    }
}

