/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class InitUtils {
    @SafeVarargs
    public static <E> List<E> asList(E ... elements) {
        return Collections.unmodifiableList(Arrays.asList(elements));
    }

    @SafeVarargs
    public static <E> Set<E> asSet(E ... elements) {
        return Collections.unmodifiableSet(new HashSet<E>(Arrays.asList(elements)));
    }

    @SafeVarargs
    public static <E extends Enum<E>> Set<E> asSet(E first, E ... rest) {
        return Collections.unmodifiableSet(EnumSet.of(first, rest));
    }

    @SafeVarargs
    public static <K extends Enum<K>, V> Map<K, V> asMap(Class<K> enumClass, Map.Entry<? extends K, ? extends V> ... entries) {
        return InitUtils.asMap(enumClass, InitUtils.throwingMerger(), entries);
    }

    @SafeVarargs
    public static <K extends Enum<K>, V> Map<K, V> asMap(Class<K> enumClass, BinaryOperator<V> merger, Map.Entry<? extends K, ? extends V> ... entries) {
        return InitUtils.asMap(() -> new EnumMap(enumClass), merger, entries);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> asMap(Map.Entry<? extends K, ? extends V> ... entries) {
        return InitUtils.asMap(InitUtils.throwingMerger(), entries);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> asMap(BinaryOperator<V> merger, Map.Entry<? extends K, ? extends V> ... entries) {
        return InitUtils.asMap(HashMap::new, merger, entries);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> asMap(Supplier<Map<K, V>> mapSupplier, BinaryOperator<V> merger, Map.Entry<? extends K, ? extends V> ... entries) {
        return Collections.unmodifiableMap(Stream.of(entries).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, merger, mapSupplier)));
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return new Entry(key, value);
    }

    public static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    private static final class Entry<EK, EV>
    implements Map.Entry<EK, EV> {
        private final EK key;
        private final EV value;

        private Entry(EK key, EV value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public EV getValue() {
            return this.value;
        }

        @Override
        public EK getKey() {
            return this.key;
        }

        @Override
        public EV setValue(EV value) {
            throw new UnsupportedOperationException();
        }
    }
}

