/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.util.function;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.xblackcat.sjpu.util.function.ConsumerEx;
import org.xblackcat.sjpu.util.function.CoveringException;

@FunctionalInterface
public interface BiConsumerEx<T, U, E extends Throwable> {
    public void accept(T var1, U var2) throws E;

    default public BiConsumerEx<T, U, E> andThen(BiConsumerEx<? super T, ? super U, E> after) {
        Objects.requireNonNull(after);
        return (l, U) -> {
            this.accept(l, U);
            after.accept(l, U);
        };
    }

    default public ConsumerEx<T, E> fixRight(U u) {
        return t -> this.accept(t, u);
    }

    default public ConsumerEx<U, E> fixLeft(T t) {
        return u -> this.accept(t, u);
    }

    default public <C extends Throwable> BiConsumerEx<T, U, C> cover(String exceptionText, BiFunction<String, Throwable, C> cover) {
        return this.cover(() -> exceptionText, cover);
    }

    default public <C extends Throwable> BiConsumerEx<T, U, C> cover(BiFunction<String, Throwable, C> cover) {
        return this.cover(Throwable::getMessage, cover);
    }

    default public <C extends Throwable> BiConsumerEx<T, U, C> cover(Supplier<String> text, BiFunction<String, Throwable, C> cover) {
        return this.cover((Throwable e) -> (String)text.get(), cover);
    }

    default public <C extends Throwable> BiConsumerEx<T, U, C> cover(Function<Throwable, String> text, BiFunction<String, Throwable, C> cover) {
        return (t, u) -> {
            try {
                this.accept(t, u);
            }
            catch (Throwable e) {
                throw (Throwable)cover.apply((String)text.apply(e), e);
            }
        };
    }

    default public BiConsumer<T, U> unchecked(String exceptionText, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked(() -> exceptionText, cover);
    }

    default public BiConsumer<T, U> unchecked() {
        return this.unchecked(CoveringException::new);
    }

    default public BiConsumer<T, U> unchecked(BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked(Throwable::getMessage, cover);
    }

    default public BiConsumer<T, U> unchecked(Supplier<String> text, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked((Throwable e) -> (String)text.get(), cover);
    }

    default public BiConsumer<T, U> unchecked(Function<Throwable, String> text, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return (t, u) -> {
            try {
                this.accept(t, u);
            }
            catch (Throwable e) {
                throw (RuntimeException)cover.apply((String)text.apply(e), e);
            }
        };
    }
}

