/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.util.function;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.xblackcat.sjpu.util.function.CoveringException;
import org.xblackcat.sjpu.util.function.FunctionEx;
import org.xblackcat.sjpu.util.function.SupplierEx;

@FunctionalInterface
public interface BiFunctionEx<T, U, R, E extends Throwable> {
    public R apply(T var1, U var2) throws E;

    default public <V> BiFunctionEx<T, U, V, E> andThen(FunctionEx<? super R, ? extends V, E> after) {
        Objects.requireNonNull(after);
        return (t, u) -> after.apply((R)this.apply(t, u));
    }

    default public FunctionEx<T, R, E> fixRight(U u) {
        return t -> this.apply(t, u);
    }

    default public FunctionEx<U, R, E> fixLeft(T t) {
        return u -> this.apply(t, u);
    }

    default public SupplierEx<R, E> fix(T t, U u) {
        return () -> this.apply(t, u);
    }

    default public <C extends Throwable> BiFunctionEx<T, U, R, C> cover(String exceptionText, BiFunction<String, Throwable, C> cover) {
        return this.cover(() -> exceptionText, cover);
    }

    default public <C extends Throwable> BiFunctionEx<T, U, R, C> cover(BiFunction<String, Throwable, C> cover) {
        return this.cover(Throwable::getMessage, cover);
    }

    default public <C extends Throwable> BiFunctionEx<T, U, R, C> cover(Supplier<String> text, BiFunction<String, Throwable, C> cover) {
        return this.cover((Throwable e) -> (String)text.get(), cover);
    }

    default public <C extends Throwable> BiFunctionEx<T, U, R, C> cover(Function<Throwable, String> text, BiFunction<String, Throwable, C> cover) {
        return (t, u) -> {
            try {
                return this.apply(t, u);
            }
            catch (Throwable e) {
                throw (Throwable)cover.apply((String)text.apply(e), e);
            }
        };
    }

    default public BiFunction<T, U, R> unchecked(String exceptionText, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked(() -> exceptionText, cover);
    }

    default public BiFunction<T, U, R> unchecked() {
        return this.unchecked(CoveringException::new);
    }

    default public BiFunction<T, U, R> unchecked(BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked(Throwable::getMessage, cover);
    }

    default public BiFunction<T, U, R> unchecked(Supplier<String> text, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked((Throwable e) -> (String)text.get(), cover);
    }

    default public BiFunction<T, U, R> unchecked(Function<Throwable, String> text, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return (t, u) -> {
            try {
                return this.apply(t, u);
            }
            catch (Throwable e) {
                throw (RuntimeException)cover.apply((String)text.apply(e), e);
            }
        };
    }
}

