/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.util.function;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import org.xblackcat.sjpu.util.function.BooleanSupplierEx;
import org.xblackcat.sjpu.util.function.ConsumerEx;
import org.xblackcat.sjpu.util.function.CoveringException;

@FunctionalInterface
public interface BiPredicateEx<T, U, E extends Throwable> {
    public boolean test(T var1, U var2) throws E;

    default public BiPredicateEx<T, U, E> and(BiPredicateEx<? super T, ? super U, E> other) {
        Objects.requireNonNull(other);
        return (t, u) -> this.test(t, u) && other.test(t, u);
    }

    default public BiPredicateEx<T, U, E> negate() {
        return (t, u) -> !this.test(t, u);
    }

    default public BiPredicateEx<T, U, E> or(BiPredicateEx<? super T, ? super U, E> other) {
        Objects.requireNonNull(other);
        return (t, u) -> this.test(t, u) || other.test(t, u);
    }

    default public ConsumerEx<T, E> fixRight(U u) {
        return t -> this.test(t, u);
    }

    default public ConsumerEx<U, E> fixLeft(T t) {
        return u -> this.test(t, u);
    }

    default public BooleanSupplierEx<E> fix(T t, U u) {
        return () -> this.test(t, u);
    }

    default public <C extends Throwable> BiPredicateEx<T, U, C> cover(String exceptionText, BiFunction<String, Throwable, C> cover) {
        return this.cover(() -> exceptionText, cover);
    }

    default public <C extends Throwable> BiPredicateEx<T, U, C> cover(BiFunction<String, Throwable, C> cover) {
        return this.cover(Throwable::getMessage, cover);
    }

    default public <C extends Throwable> BiPredicateEx<T, U, C> cover(Supplier<String> text, BiFunction<String, Throwable, C> cover) {
        return this.cover((Throwable e) -> (String)text.get(), cover);
    }

    default public <C extends Throwable> BiPredicateEx<T, U, C> cover(Function<Throwable, String> text, BiFunction<String, Throwable, C> cover) {
        return (t, u) -> {
            try {
                return this.test(t, u);
            }
            catch (Throwable e) {
                throw (Throwable)cover.apply((String)text.apply(e), e);
            }
        };
    }

    default public BiPredicate<T, U> unchecked(String exceptionText, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked(() -> exceptionText, cover);
    }

    default public BiPredicate<T, U> unchecked() {
        return this.unchecked(CoveringException::new);
    }

    default public BiPredicate<T, U> unchecked(BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked(Throwable::getMessage, cover);
    }

    default public BiPredicate<T, U> unchecked(Supplier<String> text, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked((Throwable e) -> (String)text.get(), cover);
    }

    default public BiPredicate<T, U> unchecked(Function<Throwable, String> text, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return (t, u) -> {
            try {
                return this.test(t, u);
            }
            catch (Throwable e) {
                throw (RuntimeException)cover.apply((String)text.apply(e), e);
            }
        };
    }
}

