/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.util.function;

import java.util.Comparator;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import org.xblackcat.sjpu.util.function.BiFunctionEx;
import org.xblackcat.sjpu.util.function.CoveringException;
import org.xblackcat.sjpu.util.function.UnaryOperatorEx;

@FunctionalInterface
public interface BinaryOperatorEx<T, E extends Throwable>
extends BiFunctionEx<T, T, T, E> {
    public static <T, E extends Throwable> BinaryOperatorEx<T, E> minBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return (a, b) -> comparator.compare(a, b) <= 0 ? a : b;
    }

    public static <T, E extends Throwable> BinaryOperatorEx<T, E> maxBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return (a, b) -> comparator.compare(a, b) >= 0 ? a : b;
    }

    default public UnaryOperatorEx<T, E> fixRight(T u) {
        return t -> this.apply(t, u);
    }

    default public UnaryOperatorEx<T, E> fixLeft(T t) {
        return u -> this.apply(t, u);
    }

    default public <C extends Throwable> BinaryOperatorEx<T, C> cover(String exceptionText, BiFunction<String, Throwable, C> cover) {
        return this.cover(() -> exceptionText, (BiFunction)cover);
    }

    default public <C extends Throwable> BinaryOperatorEx<T, C> cover(BiFunction<String, Throwable, C> cover) {
        return this.cover(Throwable::getMessage, (BiFunction)cover);
    }

    default public <C extends Throwable> BinaryOperatorEx<T, C> cover(Supplier<String> text, BiFunction<String, Throwable, C> cover) {
        return this.cover(e -> (String)text.get(), (BiFunction)cover);
    }

    default public <C extends Throwable> BinaryOperatorEx<T, C> cover(Function<Throwable, String> text, BiFunction<String, Throwable, C> cover) {
        return (t, u) -> {
            try {
                return this.apply(t, u);
            }
            catch (Throwable e) {
                throw (Throwable)cover.apply((String)text.apply(e), e);
            }
        };
    }

    default public BinaryOperator<T> unchecked(String exceptionText, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked(() -> exceptionText, (BiFunction)cover);
    }

    default public BinaryOperator<T> unchecked() {
        return this.unchecked(CoveringException::new);
    }

    default public BinaryOperator<T> unchecked(BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked(Throwable::getMessage, (BiFunction)cover);
    }

    default public BinaryOperator<T> unchecked(Supplier<String> text, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked(e -> (String)text.get(), (BiFunction)cover);
    }

    default public BinaryOperator<T> unchecked(Function<Throwable, String> text, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return (t, u) -> {
            try {
                return this.apply(t, u);
            }
            catch (Throwable e) {
                throw (RuntimeException)cover.apply((String)text.apply(e), e);
            }
        };
    }
}

