/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.util.function;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.xblackcat.sjpu.util.function.CoveringException;

@FunctionalInterface
public interface ConsumerEx<T, E extends Throwable> {
    public void accept(T var1) throws E;

    default public ConsumerEx<T, E> andThen(ConsumerEx<? super T, E> after) {
        Objects.requireNonNull(after);
        return t -> {
            this.accept(t);
            after.accept(t);
        };
    }

    default public <C extends Throwable> ConsumerEx<T, C> cover(String exceptionText, BiFunction<String, Throwable, C> cover) {
        return this.cover(() -> exceptionText, cover);
    }

    default public <C extends Throwable> ConsumerEx<T, C> cover(BiFunction<String, Throwable, C> cover) {
        return this.cover(Throwable::getMessage, cover);
    }

    default public <C extends Throwable> ConsumerEx<T, C> cover(Supplier<String> text, BiFunction<String, Throwable, C> cover) {
        return this.cover((Throwable e) -> (String)text.get(), cover);
    }

    default public <C extends Throwable> ConsumerEx<T, C> cover(Function<Throwable, String> text, BiFunction<String, Throwable, C> cover) {
        return t -> {
            try {
                this.accept(t);
            }
            catch (Throwable e) {
                throw (Throwable)cover.apply((String)text.apply(e), e);
            }
        };
    }

    default public Consumer<T> unchecked(String exceptionText, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked(() -> exceptionText, cover);
    }

    default public Consumer<T> unchecked() {
        return this.unchecked(CoveringException::new);
    }

    default public Consumer<T> unchecked(BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked(Throwable::getMessage, cover);
    }

    default public Consumer<T> unchecked(Supplier<String> text, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked((Throwable e) -> (String)text.get(), cover);
    }

    default public Consumer<T> unchecked(Function<Throwable, String> text, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return t -> {
            try {
                this.accept(t);
            }
            catch (Throwable e) {
                throw (RuntimeException)cover.apply((String)text.apply(e), e);
            }
        };
    }
}

