/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.util.function;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import org.xblackcat.sjpu.util.function.BooleanSupplierEx;
import org.xblackcat.sjpu.util.function.CoveringException;

@FunctionalInterface
public interface DoublePredicateEx<E extends Throwable> {
    public boolean test(double var1) throws E;

    default public DoublePredicateEx<E> and(DoublePredicateEx<E> other) {
        Objects.requireNonNull(other);
        return value -> this.test(value) && other.test(value);
    }

    default public DoublePredicateEx<E> negate() {
        return value -> !this.test(value);
    }

    default public DoublePredicateEx<E> or(DoublePredicateEx<E> other) {
        Objects.requireNonNull(other);
        return value -> this.test(value) || other.test(value);
    }

    default public BooleanSupplierEx<E> fix(double value) {
        return () -> this.test(value);
    }

    default public <C extends Throwable> DoublePredicateEx<C> cover(String exceptionText, BiFunction<String, Throwable, C> cover) {
        return this.cover(() -> exceptionText, cover);
    }

    default public <C extends Throwable> DoublePredicateEx<C> cover(BiFunction<String, Throwable, C> cover) {
        return this.cover(Throwable::getMessage, cover);
    }

    default public <C extends Throwable> DoublePredicateEx<C> cover(Supplier<String> text, BiFunction<String, Throwable, C> cover) {
        return this.cover((Throwable e) -> (String)text.get(), cover);
    }

    default public <C extends Throwable> DoublePredicateEx<C> cover(Function<Throwable, String> text, BiFunction<String, Throwable, C> cover) {
        return t -> {
            try {
                return this.test(t);
            }
            catch (Throwable e) {
                throw (Throwable)cover.apply((String)text.apply(e), e);
            }
        };
    }

    default public DoublePredicate unchecked(String exceptionText, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked(() -> exceptionText, cover);
    }

    default public DoublePredicate unchecked() {
        return this.unchecked(CoveringException::new);
    }

    default public DoublePredicate unchecked(BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked(Throwable::getMessage, cover);
    }

    default public DoublePredicate unchecked(Supplier<String> text, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked((Throwable e) -> (String)text.get(), cover);
    }

    default public DoublePredicate unchecked(Function<Throwable, String> text, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return t -> {
            try {
                return this.test(t);
            }
            catch (Throwable e) {
                throw (RuntimeException)cover.apply((String)text.apply(e), e);
            }
        };
    }
}

