/*
 * Decompiled with CFR 0.152.
 */
package org.xblackcat.sjpu.util.function;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.xblackcat.sjpu.util.function.BooleanSupplierEx;
import org.xblackcat.sjpu.util.function.CoveringException;

@FunctionalInterface
public interface PredicateEx<T, E extends Throwable> {
    public static <T, E extends Throwable> PredicateEx<T, E> isEqual(Object targetRef) throws E {
        return null == targetRef ? Objects::isNull : targetRef::equals;
    }

    public boolean test(T var1) throws E;

    default public PredicateEx<T, E> and(PredicateEx<? super T, E> other) throws E {
        Objects.requireNonNull(other);
        return t -> this.test(t) && other.test(t);
    }

    default public PredicateEx<T, E> negate() throws E {
        return t -> !this.test(t);
    }

    default public PredicateEx<T, E> or(PredicateEx<? super T, E> other) throws E {
        Objects.requireNonNull(other);
        return t -> this.test(t) || other.test(t);
    }

    default public BooleanSupplierEx<E> fix(T t) {
        return () -> this.test(t);
    }

    default public <C extends Throwable> PredicateEx<T, C> cover(String exceptionText, BiFunction<String, Throwable, C> cover) {
        return this.cover(() -> exceptionText, cover);
    }

    default public <C extends Throwable> PredicateEx<T, C> cover(BiFunction<String, Throwable, C> cover) {
        return this.cover(Throwable::getMessage, cover);
    }

    default public <C extends Throwable> PredicateEx<T, C> cover(Supplier<String> text, BiFunction<String, Throwable, C> cover) {
        return this.cover((Throwable e) -> (String)text.get(), cover);
    }

    default public <C extends Throwable> PredicateEx<T, C> cover(Function<Throwable, String> text, BiFunction<String, Throwable, C> cover) {
        return t -> {
            try {
                return this.test(t);
            }
            catch (Throwable e) {
                throw (Throwable)cover.apply((String)text.apply(e), e);
            }
        };
    }

    default public Predicate<T> unchecked(String exceptionText, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked(() -> exceptionText, cover);
    }

    default public Predicate<T> unchecked() {
        return this.unchecked(CoveringException::new);
    }

    default public Predicate<T> unchecked(BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked(Throwable::getMessage, cover);
    }

    default public Predicate<T> unchecked(Supplier<String> text, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return this.unchecked((Throwable e) -> (String)text.get(), cover);
    }

    default public Predicate<T> unchecked(Function<Throwable, String> text, BiFunction<String, Throwable, ? extends RuntimeException> cover) {
        return t -> {
            try {
                return this.test(t);
            }
            catch (Throwable e) {
                throw (RuntimeException)cover.apply((String)text.apply(e), e);
            }
        };
    }
}

